/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventJXTableModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.font.TextAttribute;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.administration.priority.PriorityValue;
import se.streamsource.streamflow.api.workspace.cases.CaseStates;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.ui.DateFormats;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseTableValue;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableModel;
import se.streamsource.streamflow.client.ui.workspace.table.GroupBy;
import se.streamsource.streamflow.client.ui.workspace.table.PerspectiveView;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.client.util.table.SeparatorTable;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.EventParameters;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class CasesTableView
extends JPanel
implements TransactionListener {
    @Structure
    Module module;
    public static final int MILLIS_IN_DAY = 86400000;
    public static final WorkspaceResources[] dueGroups = new WorkspaceResources[]{WorkspaceResources.overdue, WorkspaceResources.duetoday, WorkspaceResources.duetomorrow, WorkspaceResources.duenextweek, WorkspaceResources.duenextmonth, WorkspaceResources.later, WorkspaceResources.noduedate};
    private Comparator<CaseTableValue> groupingComparator = new Comparator<CaseTableValue>(){

        @Override
        public int compare(CaseTableValue o1, CaseTableValue o2) {
            GroupBy groupBy = CasesTableView.this.model.getGroupBy();
            switch (groupBy) {
                case caseType: {
                    return ((String)o1.caseType().get()).compareTo((String)o2.caseType().get());
                }
                case dueOn: {
                    return CasesTableView.this.dueOnGroup((Date)o1.dueOn().get()).compareTo(CasesTableView.this.dueOnGroup((Date)o2.dueOn().get()));
                }
                case assignee: {
                    return ((String)o1.assignedTo().get()).compareTo((String)o2.assignedTo().get());
                }
                case project: {
                    return ((String)o1.owner().get()).compareTo((String)o2.owner().get());
                }
                case priority: {
                    Integer prio1 = o1.priority().get() != null ? (Integer)((PriorityValue)o1.priority().get()).priority().get() : new Integer(9999);
                    Integer prio2 = o2.priority().get() != null ? (Integer)((PriorityValue)o2.priority().get()).priority().get() : new Integer(9999);
                    return prio1.compareTo(prio2);
                }
            }
            return 0;
        }
    };
    protected JXTable caseTable;
    protected CasesTableModel model;
    private TableFormat tableFormat;
    private ApplicationContext context;
    private PerspectiveView filter;

    public void init(final @Service ApplicationContext context, @Uses CasesTableModel casesTableModel, final @Uses TableFormat tableFormat, @Optional @Uses JTextField searchField) {
        this.setLayout(new BorderLayout());
        this.context = context;
        this.model = casesTableModel;
        this.tableFormat = tableFormat;
        ApplicationActionMap am = context.getActionMap(CasesTableView.class, (Object)this);
        this.setActionMap((ActionMap)am);
        MacOsUIWrapper.convertAccelerators((ActionMap)context.getActionMap(CasesTableView.class, (Object)this));
        this.filter = (PerspectiveView)this.module.objectBuilderFactory().newObjectBuilder(PerspectiveView.class).use(new Object[]{this.model, searchField}).newInstance();
        this.add((Component)this.filter, "North");
        this.caseTable = new SeparatorTable(null){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                EventTableModel model = (EventTableModel)this.getModel();
                if (model.getElementAt(row) instanceof CaseTableValue) {
                    Map<TextAttribute, ?> attributes = c.getFont().getAttributes();
                    if (((Boolean)((CaseTableValue)model.getElementAt(row)).removed().get()).booleanValue()) {
                        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                    } else if (((Boolean)((CaseTableValue)model.getElementAt(row)).unread().get()).booleanValue()) {
                        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    }
                    c.setFont(new Font(attributes));
                }
                return c;
            }
        };
        this.caseTable.setSelectionMode(0);
        this.caseTable.getActionMap().getParent().setParent((ActionMap)am);
        this.caseTable.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        this.caseTable.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        this.caseTable.getActionMap().remove("column.horizontalScroll");
        this.caseTable.getActionMap().remove("column.packAll");
        this.caseTable.getActionMap().remove("column.packSelected");
        this.caseTable.setColumnControlVisible(true);
        this.caseTable.setModel((TableModel)new EventJXTableModel(this.model.getEventList(), tableFormat));
        this.model.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (CasesTableView.this.model.getGroupBy() == GroupBy.none) {
                    CasesTableView.this.caseTable.setModel((TableModel)new EventJXTableModel(CasesTableView.this.model.getEventList(), tableFormat));
                } else {
                    SeparatorList groupingList = new SeparatorList(CasesTableView.this.model.getEventList(), CasesTableView.this.groupingComparator, 1, 10000);
                    CasesTableView.this.caseTable.setModel((TableModel)new EventJXTableModel((EventList)groupingList, tableFormat));
                }
                if (!CasesTableView.this.model.containsCaseWithPriority()) {
                    CasesTableView.this.model.addInvisibleColumn(8);
                }
                for (Integer invisibleCol : CasesTableView.this.model.getInvisibleColumns()) {
                    TableColumnModelExt tm = (TableColumnModelExt)CasesTableView.this.caseTable.getColumnModel();
                    if (!tm.getColumnExt((Object)invisibleCol).isVisible()) continue;
                    CasesTableView.this.caseTable.getColumnExt((Object)invisibleCol).setVisible(false);
                }
            }
        });
        this.caseTable.getColumn(0).setPreferredWidth(500);
        this.caseTable.getColumn(1).setPreferredWidth(70);
        this.caseTable.getColumn(1).setMaxWidth(70);
        this.caseTable.getColumn(1).setResizable(false);
        this.caseTable.getColumn(2).setPreferredWidth(300);
        this.caseTable.getColumn(2).setMaxWidth(300);
        this.caseTable.getColumn(3).setPreferredWidth(150);
        this.caseTable.getColumn(3).setMaxWidth(150);
        this.caseTable.getColumn(4).setPreferredWidth(90);
        this.caseTable.getColumn(4).setMaxWidth(90);
        this.caseTable.getColumn(5).setPreferredWidth(150);
        this.caseTable.getColumn(5).setMaxWidth(150);
        this.caseTable.getColumn(6).setPreferredWidth(90);
        this.caseTable.getColumn(6).setMaxWidth(90);
        this.caseTable.getColumn(7).setPreferredWidth(150);
        this.caseTable.getColumn(7).setMaxWidth(150);
        this.caseTable.getColumn(7).setResizable(false);
        this.caseTable.getColumn(8).setPreferredWidth(100);
        this.caseTable.getColumn(8).setMaxWidth(100);
        this.caseTable.getColumn(9).setMaxWidth(50);
        this.caseTable.getColumn(9).setResizable(false);
        this.caseTable.setAutoCreateColumnsFromModel(false);
        int count = 0;
        for (TableColumn c : this.caseTable.getColumns()) {
            c.setIdentifier(count);
            ++count;
            c.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("visible".equals(evt.getPropertyName())) {
                        TableColumnExt columnExt = (TableColumnExt)evt.getSource();
                        if (columnExt.isVisible()) {
                            CasesTableView.this.model.removeInvisibleColumn(columnExt.getModelIndex());
                        } else {
                            CasesTableView.this.model.addInvisibleColumn(columnExt.getModelIndex());
                        }
                    }
                }
            });
        }
        JScrollPane caseScrollPane = new JScrollPane((Component)this.caseTable, 22, 30);
        this.add((Component)caseScrollPane, "Center");
        this.caseTable.setDefaultRenderer(Date.class, (TableCellRenderer)new DefaultTableRenderer(new StringValue(){
            private static final long serialVersionUID = 4782416330896582518L;

            public String getString(Object value) {
                return value != null ? DateFormats.getProgressiveDateTimeValue((Date)value, Locale.getDefault()) : "";
            }
        }));
        this.caseTable.setDefaultRenderer(ArrayList.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    return this;
                }
                if (value instanceof SeparatorList.Separator) {
                    return CasesTableView.this.caseTable.getDefaultRenderer(SeparatorList.Separator.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                JPanel renderer = new JPanel(new FlowLayout(0));
                ArrayList icons = (ArrayList)value;
                for (String icon : icons) {
                    ImageIcon image = i18n.icon(Icons.valueOf(icon), 11);
                    JLabel iconLabel = image != null ? new JLabel(image, 10) : new JLabel("   ");
                    renderer.add(iconLabel);
                }
                if (isSelected) {
                    renderer.setBackground(table.getSelectionBackground());
                }
                return renderer;
            }
        });
        this.caseTable.setDefaultRenderer(CaseStates.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    return this;
                }
                EventTableModel model = (EventTableModel)table.getModel();
                boolean hasResolution = !Strings.empty((String)((String)((CaseTableValue)model.getElementAt(row)).resolution().get()));
                boolean removed = (Boolean)((CaseTableValue)model.getElementAt(row)).removed().get();
                String iconName = hasResolution ? "case_status_withresolution_" + value.toString().toLowerCase() + "_icon" : "case_status_" + value.toString().toLowerCase() + "_icon";
                iconName = removed ? "case_status_draft_icon" : iconName;
                JLabel renderedComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                renderedComponent.setHorizontalAlignment(0);
                this.setText(null);
                this.setIcon(i18n.icon(CaseResources.valueOf(iconName), 16));
                this.setName(i18n.text(CaseResources.valueOf("case_status_" + value.toString().toLowerCase() + "_text"), new Object[0]));
                this.setToolTipText(i18n.text(CaseResources.valueOf("case_status_" + value.toString().toLowerCase() + "_text"), new Object[0]));
                return this;
            }
        });
        this.caseTable.setDefaultRenderer(PriorityValue.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                final PriorityValue priority = (PriorityValue)value;
                String val = priority == null ? "" : (String)priority.text().get();
                JPanel panel = new JPanel();
                FormLayout layout = new FormLayout("10dlu, 50dlu:grow", "pref");
                DefaultFormBuilder formBuilder = new DefaultFormBuilder(layout, panel);
                panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                JLabel label = new JLabel(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void paintComponent(Graphics g) {
                        Color color = this.getBackground();
                        if (priority != null) {
                            color = !Strings.empty((String)((String)priority.color().get())) ? new Color(Integer.parseInt((String)priority.color().get())) : Color.BLACK;
                        }
                        Color FILL_COLOR = ColorUtil.removeAlpha((Color)color);
                        Graphics2D g2 = (Graphics2D)g.create();
                        try {
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2.setColor(Color.LIGHT_GRAY);
                            int DIAM = Math.min(this.getWidth(), this.getHeight());
                            int inset = 3;
                            g2.fill(new Ellipse2D.Float(3.0f, 3.0f, DIAM - 6, DIAM - 6));
                            g2.setColor(FILL_COLOR);
                            boolean border = true;
                            g2.fill(new Ellipse2D.Float(4.0f, 4.0f, DIAM - 6 - 2, DIAM - 6 - 2));
                        }
                        finally {
                            g2.dispose();
                        }
                    }
                };
                label.setPreferredSize(new Dimension(10, 10));
                formBuilder.add((Component)(Strings.empty((String)val) || "-".equals(val) ? new JLabel() : label), new CellConstraints(1, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
                JLabel text = new JLabel(val);
                formBuilder.add((Component)text, new CellConstraints(2, 1, 1, 1, CellConstraints.LEFT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
                if (isSelected) {
                    panel.setBackground(table.getSelectionBackground());
                    text.setForeground(table.getSelectionForeground());
                }
                return panel;
            }
        });
        this.caseTable.setDefaultRenderer(SeparatorList.Separator.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object separator, boolean isSelected, boolean hasFocus, int row, int column) {
                String value = "";
                boolean emptyDescription = false;
                switch (CasesTableView.this.model.getGroupBy()) {
                    case caseType: {
                        emptyDescription = Strings.empty((String)((String)((CaseTableValue)((SeparatorList.Separator)separator).first()).caseType().get()));
                        value = !emptyDescription ? (String)((CaseTableValue)((SeparatorList.Separator)separator).first()).caseType().get() : i18n.text(WorkspaceResources.no_casetype, new Object[0]);
                        break;
                    }
                    case assignee: {
                        emptyDescription = Strings.empty((String)((String)((CaseTableValue)((SeparatorList.Separator)separator).first()).assignedTo().get()));
                        value = !emptyDescription ? (String)((CaseTableValue)((SeparatorList.Separator)separator).first()).assignedTo().get() : i18n.text(WorkspaceResources.no_assignee, new Object[0]);
                        break;
                    }
                    case project: {
                        emptyDescription = Strings.empty((String)((String)((CaseTableValue)((SeparatorList.Separator)separator).first()).owner().get()));
                        value = !emptyDescription ? (String)((CaseTableValue)((SeparatorList.Separator)separator).first()).owner().get() : i18n.text(WorkspaceResources.no_project, new Object[0]);
                        break;
                    }
                    case dueOn: {
                        value = i18n.text(dueGroups[CasesTableView.this.dueOnGroup((Date)((CaseTableValue)((SeparatorList.Separator)separator).first()).dueOn().get())], new Object[0]);
                        break;
                    }
                    case priority: {
                        emptyDescription = ((CaseTableValue)((SeparatorList.Separator)separator).first()).priority().get() == null || Strings.empty((String)((String)((PriorityValue)((CaseTableValue)((SeparatorList.Separator)separator).first()).priority().get()).color().get()));
                        value = !emptyDescription ? (String)((PriorityValue)((CaseTableValue)((SeparatorList.Separator)separator).first()).priority().get()).text().get() : i18n.text(WorkspaceResources.no_priority, new Object[0]);
                    }
                }
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setFont(component.getFont().deriveFont(3));
                component.setBackground(Color.lightGray);
                return component;
            }
        });
        AbstractHighlighter separatorHighlighter = (AbstractHighlighter)HighlighterFactory.createSimpleStriping((Color)HighlighterFactory.QUICKSILVER);
        separatorHighlighter.setHighlightPredicate((HighlightPredicate)new HighlightPredicate.TypeHighlightPredicate(SeparatorList.Separator.class));
        this.caseTable.addHighlighter(HighlighterFactory.createAlternateStriping());
        this.caseTable.addHighlighter((Highlighter)separatorHighlighter);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CasesTableView.this.caseTable.requestFocusInWindow();
            }
        });
        this.model.getEventList().addListEventListener((ListEventListener)new ListEventListener<CaseTableValue>(){

            public void listChanged(ListEvent<CaseTableValue> listChanges) {
                HashSet<Object> labels = new HashSet<Object>();
                HashSet<Object> assignees = new HashSet<Object>();
                HashSet<Object> projects = new HashSet<Object>();
                for (CaseTableValue caseTableValue : listChanges.getSourceList()) {
                    for (LinkValue linkValue : (List)((LinksValue)caseTableValue.labels().get()).links().get()) {
                        labels.add(linkValue.text().get());
                    }
                    assignees.add(caseTableValue.assignedTo().get());
                    projects.add(caseTableValue.owner().get());
                }
                ArrayList<String> sortedLabels = new ArrayList<String>(labels);
                ArrayList<String> sortedAssignees = new ArrayList<String>(assignees);
                ArrayList<String> sortedProjects = new ArrayList<String>(projects);
                Collections.sort(sortedLabels);
                Collections.sort(sortedAssignees);
                Collections.sort(sortedProjects);
                sortedLabels.add(0, i18n.text(WorkspaceResources.all, new Object[0]));
                sortedAssignees.add(0, i18n.text(WorkspaceResources.all, new Object[0]));
                sortedProjects.add(0, i18n.text(WorkspaceResources.all, new Object[0]));
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) > 0L && CasesTableView.this.isShowing()) {
                    context.getActionMap().get((Object)"savePerspective").setEnabled(true);
                }
            }
        });
        new RefreshWhenShowing(this, this.model);
    }

    public JXTable getCaseTable() {
        return this.caseTable;
    }

    public CasesTableModel getModel() {
        return this.model;
    }

    private Integer dueOnGroup(Date date) {
        long currentTime = System.currentTimeMillis();
        currentTime /= 86400000L;
        Date today = new Date(currentTime *= 86400000L);
        Date lateToday = new Date(currentTime + 86400000L - 1L);
        Calendar month = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        month.setTime(today);
        month.add(2, 1);
        Calendar week = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        week.setTime(today);
        week.add(3, 1);
        Calendar tomorrow = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        tomorrow.setTime(lateToday);
        tomorrow.add(5, 1);
        int group = date == null ? 6 : (date.after(month.getTime()) ? 5 : (date.after(week.getTime()) ? 4 : (date.after(tomorrow.getTime()) ? 3 : (date.after(lateToday) ? 2 : (date.after(today) ? 1 : 0)))));
        return group;
    }

    public void notifyTransactions(final Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"createdCase"}), transactions)) {
            final DomainEvent event = (DomainEvent)Iterables.first((Iterable)Iterables.filter((Specification)Events.withNames((String[])new String[]{"createdCase"}), (Iterable)Events.events(transactions)));
            this.context.getTaskService().execute((Task)new CommandTask(){

                @Override
                protected void command() throws Exception {
                    CasesTableView.this.model.refresh();
                }

                @Override
                protected void succeeded(Iterable<TransactionDomainEvents> transactionEventsIterable) {
                    super.succeeded(transactionEventsIterable);
                    TableModel model = CasesTableView.this.caseTable.getModel();
                    boolean rowFound = false;
                    int n = model.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        if (!model.getValueAt(i, model.getColumnCount()).toString().endsWith(EventParameters.getParameter((DomainEvent)event, (String)"param1") + "/")) continue;
                        CasesTableView.this.caseTable.getSelectionModel().setSelectionInterval(CasesTableView.this.caseTable.convertRowIndexToView(i), CasesTableView.this.caseTable.convertRowIndexToView(i));
                        CasesTableView.this.caseTable.scrollRectToVisible(CasesTableView.this.caseTable.getCellRect(i, 0, true));
                        rowFound = true;
                        break;
                    }
                }
            });
        } else if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedLabel", "removedLabel", "changedDescription", "changedCaseType", "changedStatus", "changedOwner", "assignedTo", "unassigned", "changedRemoved", "deletedEntity", "updatedContact", "addedContact", "deletedContact", "createdConversation", "changedDueOn", "submittedForm", "createdAttachment", "removedAttachment", "changedPriority", "setUnread", "createdMessageFromDraft"}), transactions)) {
            this.context.getTaskService().execute((Task)new CommandTask(){

                @Override
                protected void command() throws Exception {
                    CasesTableView.this.model.refresh();
                    if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedStatus", "changedOwner", "assignedTo", "unassigned", "deletedEntity"}), (Iterable)transactions)) {
                        CasesTableView.this.caseTable.getSelectionModel().clearSelection();
                    }
                }
            });
        }
    }
}

