/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.search.SearchResultTableModel;
import se.streamsource.streamflow.client.ui.workspace.table.PerspectiveView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class SearchView
extends JPanel {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private JTextField searchField;
    private final SearchResultTableModel searchResultTableModel;
    private JPanel search;

    public SearchView(@Service ApplicationContext context, @Uses SearchResultTableModel searchResultTableModel) {
        this.setLayout(new BoxLayout(this, 0));
        this.searchResultTableModel = searchResultTableModel;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        javax.swing.Action searchAction = am.get("search");
        StreamflowButton searchButton = new StreamflowButton(searchAction);
        searchButton.registerKeyboardAction(searchAction, (KeyStroke)searchAction.getValue("AcceleratorKey"), 2);
        this.searchField = new JTextField(40);
        this.searchField.addActionListener(searchAction);
        this.search = new JPanel(new FlowLayout(0));
        this.search.add(this.searchField);
        this.search.add(searchButton);
        this.add(this.search);
        new RefreshWhenShowing(this, new Refreshable(){

            @Override
            public void refresh() {
                SearchView.this.getTextField().requestFocusInWindow();
            }
        });
    }

    public JTextField getTextField() {
        return this.searchField;
    }

    @Action
    public Task search() {
        if (!this.closedOpenPerspectivePopups(WindowUtils.findWindow((Component)this))) {
            final String searchString = this.getTextField().getText();
            if (searchString.length() > 500) {
                this.dialogs.showMessageDialog(this, i18n.text(WorkspaceResources.too_long_query, new Object[0]), "");
            } else {
                return new Task<Void, Void>(Application.getInstance()){

                    protected Void doInBackground() throws Exception {
                        SearchView.this.searchResultTableModel.search(searchString);
                        return null;
                    }

                    protected void succeeded(Void result) {
                    }

                    protected void failed(Throwable cause) {
                    }
                };
            }
        }
        return null;
    }

    private boolean closedOpenPerspectivePopups(Container container) {
        for (Component c : container.getComponents()) {
            if (!(c instanceof Container)) continue;
            if (c instanceof PerspectiveView) {
                PerspectiveView view = (PerspectiveView)c;
                if (view.getCurrentPopup() == null) continue;
                view.killPopup();
                view.cleanToggleButtonSelection();
                return true;
            }
            this.closedOpenPerspectivePopups((Container)c);
        }
        return false;
    }
}

