/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.MouseInputListener;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.GeoPosition;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoLocationFieldPanelResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoMarkerHolder;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.LineMarker;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.LinePainter;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.MapInteractionMode;
import se.streamsource.streamflow.client.util.i18n;

public class LineSelectionInteractionMode
implements MapInteractionMode,
MouseInputListener {
    private List<GeoPosition> points;
    private LinePainter linePainter;
    private JXMapViewer mapViewer;
    private GeoMarkerHolder geoMarkerHolder;

    @Override
    public void enterMode(JXMapViewer mapViewer, GeoMarkerHolder geoMarkerHolder) {
        mapViewer.addMouseListener((MouseListener)this);
        mapViewer.addMouseMotionListener((MouseMotionListener)this);
        this.points = new ArrayList<GeoPosition>();
        this.linePainter = new LinePainter();
        this.linePainter.setPoints(this.points);
        mapViewer.setOverlayPainter((Painter)this.linePainter);
        this.mapViewer = mapViewer;
        this.geoMarkerHolder = geoMarkerHolder;
    }

    @Override
    public void leaveMode(JXMapViewer mapViewer) {
        mapViewer.removeMouseListener((MouseListener)this);
        mapViewer.removeMouseMotionListener((MouseMotionListener)this);
        mapViewer.setOverlayPainter(null);
    }

    @Override
    public String getHelpHint() {
        return i18n.text(GeoLocationFieldPanelResources.mode_hint_select_line, new Object[0]);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        GeoPosition geoPosition = this.mapViewer.convertPointToGeoPosition((Point2D)e.getPoint());
        this.points.add(geoPosition);
        this.linePainter.setPoints(this.points);
        this.mapViewer.repaint();
        if (e.getClickCount() == 2) {
            this.geoMarkerHolder.updateGeoMarker(new LineMarker(this.points));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        GeoPosition geoPosition = this.mapViewer.convertPointToGeoPosition((Point2D)e.getPoint());
        ArrayList<GeoPosition> pointsWithMousePoint = new ArrayList<GeoPosition>(this.points);
        pointsWithMousePoint.add(geoPosition);
        this.linePainter.setPoints(pointsWithMousePoint);
        this.mapViewer.repaint();
    }
}

