/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jxmapviewer.viewer.GeoPosition;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.LineMarker;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.PointMarker;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.PolygonMarker;

abstract class GeoMarker {
    GeoMarker() {
    }

    public abstract List<GeoPosition> getPoints();

    public abstract String stringify();

    public static GeoMarker parseGeoMarker(String string) {
        String trimmed = string.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (trimmed.startsWith("(")) {
            List<GeoPosition> points = GeoMarker.parsePointList(trimmed);
            if (points.get(0).equals((Object)points.get(points.size() - 1))) {
                return new PolygonMarker(points);
            }
            return new LineMarker(points);
        }
        return new PointMarker(GeoMarker.parsePoint(trimmed));
    }

    private static List<GeoPosition> parsePointList(String s) {
        ArrayList<GeoPosition> result = new ArrayList<GeoPosition>();
        while (!s.isEmpty()) {
            int endParenIndex = s.indexOf(41);
            if (endParenIndex == -1) {
                throw new IllegalArgumentException("Unterminated parenthesis in point list");
            }
            result.add(GeoMarker.parsePoint(s.substring(1, endParenIndex - 1)));
            int nextStartParenIndex = s.indexOf(40, 1);
            if (nextStartParenIndex == -1) break;
            s = s.substring(nextStartParenIndex);
        }
        return result;
    }

    private static GeoPosition parsePoint(String s) {
        String[] lonLat = s.split(",");
        if (lonLat.length != 2) {
            throw new IllegalArgumentException("Invalid position");
        }
        return new GeoPosition(Double.parseDouble(lonLat[0]), Double.parseDouble(lonLat[1]));
    }

    protected static String stringify(GeoPosition position) {
        return String.format(Locale.US, "%.15f,%.15f", position.getLatitude(), position.getLongitude());
    }
}

