/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.api.administration.form.TextAreaFieldValue;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.util.BindingFormBuilder;
import se.streamsource.streamflow.client.util.StateBinder;

public class TextAreaFieldPanel
extends AbstractFieldPanel {
    private JTextArea text;

    public TextAreaFieldPanel(@Uses FieldSubmissionDTO field, @Uses TextAreaFieldValue fieldValue) {
        super(field);
        this.setLayout(new BorderLayout());
        JScrollPane scroll = (JScrollPane)BindingFormBuilder.Fields.TEXTAREA.newField();
        this.text = (JTextArea)scroll.getViewport().getView();
        this.text.setRows((Integer)fieldValue.rows().get());
        this.text.setColumns((Integer)fieldValue.cols().get());
        this.add((Component)scroll, "West");
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setValue(String newValue) {
        this.text.setText(newValue);
    }

    @Override
    public void setBinding(final StateBinder.Binding binding) {
        this.text.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                binding.updateProperty(((JTextComponent)input).getText());
                return true;
            }
        });
    }
}

