/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.api.administration.form.NumberFieldValue;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.util.Strings;

public class NumberPanel
extends AbstractFieldPanel {
    private JTextField textField;
    @Service
    DialogService dialogs;
    private Boolean isInteger;

    public NumberPanel(@Uses FieldSubmissionDTO field, @Uses NumberFieldValue fieldValue) {
        super(field);
        this.setLayout(new BorderLayout());
        this.textField = new JTextField();
        this.textField.setColumns(20);
        this.isInteger = (Boolean)fieldValue.integer().get();
        this.add((Component)this.textField, "West");
    }

    @Override
    public String getValue() {
        return this.textField.getText();
    }

    @Override
    public void setValue(String newValue) {
        this.textField.setText(newValue);
    }

    @Override
    public void setBinding(final StateBinder.Binding binding) {
        final NumberPanel panel = this;
        this.textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JTextField field = (JTextField)input;
                String value = field.getText();
                if (!Strings.empty((String)value)) {
                    try {
                        if (NumberPanel.this.isInteger.booleanValue()) {
                            binding.updateProperty(Integer.parseInt(value));
                        } else {
                            binding.updateProperty(Double.parseDouble(value.replace(',', '.')));
                        }
                    }
                    catch (NumberFormatException e) {
                        if (NumberPanel.this.isInteger.booleanValue()) {
                            NumberPanel.this.dialogs.showMessageDialog(panel, i18n.text(CaseResources.invalidinteger, new Object[0]), "");
                        } else {
                            NumberPanel.this.dialogs.showMessageDialog(panel, i18n.text(CaseResources.invalidfloat, new Object[0]), "");
                        }
                        return false;
                    }
                }
                return true;
            }
        });
    }
}

