/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.color.ColorUtil;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.object.ObjectBuilderFactory;
import org.qi4j.api.property.Property;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.library.constraints.annotation.MaxLength;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.administration.priority.PriorityValue;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.caselog.CaseLogView;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseGeneralModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseLabelsView;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.PossibleFormsView;
import se.streamsource.streamflow.client.ui.workspace.cases.note.CaseNoteView;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.BindingFormBuilder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.UncaughtExceptionHandler;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class CaseGeneralView
extends JScrollPane
implements TransactionListener,
Refreshable {
    @Service
    private DialogService dialogs;
    @Service
    private UncaughtExceptionHandler exception;
    @Structure
    Module module;
    private ActionBinder actionBinder;
    private ValueBinder valueBinder;
    private CaseGeneralModel model;
    private JTextField descriptionField;
    private JXDatePicker dueOnField;
    private JPanel leftPane;
    private CaseLabelsView labels;
    private PossibleFormsView forms;
    private RemovableLabel selectedCaseType = new RemovableLabel();
    private StreamflowButton caseTypeButton;
    private StreamflowButton labelButton;
    private final ApplicationContext appContext;
    private CaseNoteView caseNotes;
    private JComboBox casePriority;

    public CaseGeneralView(@Service ApplicationContext appContext, @Uses CaseGeneralModel generalModel, @Uses CaseLogView caseLogView, @Structure Module module) {
        this.appContext = appContext;
        this.model = generalModel;
        RefreshComponents refreshComponents = new RefreshComponents();
        this.model.addObserver(refreshComponents);
        ObjectBuilderFactory obf = module.objectBuilderFactory();
        this.labels = (CaseLabelsView)obf.newObjectBuilder(CaseLabelsView.class).use(new Object[]{generalModel.newLabelsModel()}).newInstance();
        this.caseNotes = (CaseNoteView)obf.newObjectBuilder(CaseNoteView.class).use(new Object[]{generalModel.newCaseNoteModel()}).newInstance();
        RefreshComponents refreshLabelComponents = new RefreshComponents();
        this.labels.getModel().addObserver(refreshLabelComponents);
        this.forms = (PossibleFormsView)obf.newObjectBuilder(PossibleFormsView.class).use(new Object[]{generalModel.newPossibleFormsModel()}).newInstance();
        refreshComponents.visibleOn("changedescription", this.forms);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.getVerticalScrollBar().setUnitIncrement(30);
        this.setActionMap((ActionMap)appContext.getActionMap((Object)this));
        ActionMap am = this.getActionMap();
        MacOsUIWrapper.convertAccelerators((ActionMap)appContext.getActionMap(CaseGeneralView.class, (Object)this));
        this.actionBinder = (ActionBinder)obf.newObjectBuilder(ActionBinder.class).use(new Object[]{am}).newInstance();
        this.valueBinder = (ValueBinder)obf.newObject(ValueBinder.class);
        this.actionBinder.setResourceMap(appContext.getResourceMap(this.getClass()));
        FormLayout leftLayout = new FormLayout("70dlu, 2dlu, 200:grow, 70dlu", "pref, pref, pref, pref, 20dlu, pref, pref, pref, pref");
        this.leftPane = new JPanel((LayoutManager)leftLayout);
        this.leftPane.setFocusable(false);
        DefaultFormBuilder leftBuilder = new DefaultFormBuilder(leftLayout, this.leftPane);
        leftBuilder.setBorder(Borders.createEmptyBorder((ConstantSize)Sizes.DLUY2, (ConstantSize)Sizes.DLUX2, (ConstantSize)Sizes.DLUY2, (ConstantSize)Sizes.DLUX11));
        this.selectedCaseType.getLabel().setFont(this.selectedCaseType.getLabel().getFont().deriveFont(1));
        this.selectedCaseType.getButton().addActionListener(am.get("removeCaseType"));
        this.valueBinder.bind("caseType", this.selectedCaseType);
        leftBuilder.setExtent(3, 1);
        JLabel descriptionLabel = leftBuilder.getComponentFactory().createLabel(i18n.text(WorkspaceResources.description_label, new Object[0]));
        leftBuilder.add((Component)descriptionLabel);
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        leftBuilder.nextColumn(3);
        JLabel dueOnLabel = leftBuilder.append(i18n.text(WorkspaceResources.due_on_label, new Object[0]));
        dueOnLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        leftBuilder.nextLine();
        leftBuilder.setExtent(3, 1);
        JPanel descPanel = new JPanel(new BorderLayout());
        this.descriptionField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
        descPanel.add((Component)this.valueBinder.bind("description", this.actionBinder.bind("changeDescription", this.descriptionField)), "West");
        leftBuilder.add((Component)descPanel);
        this.descriptionField.setName("txtCaseDescription");
        this.dueOnField = (JXDatePicker)BindingFormBuilder.Fields.DATEPICKER.newField();
        leftBuilder.add((Component)this.valueBinder.bind("dueOn", this.actionBinder.bind("changeDueOn", this.dueOnField)), new CellConstraints(4, 2, 1, 1, CellConstraints.LEFT, CellConstraints.BOTTOM, new Insets(4, 0, 0, 0)));
        leftBuilder.nextLine();
        descriptionLabel.setLabelFor(this.descriptionField);
        dueOnLabel.setLabelFor((Component)this.dueOnField);
        refreshComponents.enabledOn("changedescription", this.descriptionField);
        refreshComponents.enabledOn("changedueon", new Component[]{this.dueOnField});
        javax.swing.Action caseTypeAction = am.get("changeCaseType");
        this.caseTypeButton = new StreamflowButton(caseTypeAction);
        this.caseTypeButton.registerKeyboardAction(caseTypeAction, (KeyStroke)caseTypeAction.getValue("AcceleratorKey"), 2);
        this.caseTypeButton.setHorizontalAlignment(2);
        refreshComponents.enabledOn("casetype", this.caseTypeButton, this.selectedCaseType);
        leftBuilder.add((Component)this.caseTypeButton, new CellConstraints(1, 3, 1, 1, CellConstraints.FILL, CellConstraints.TOP, new Insets(2, 0, 5, 0)));
        leftBuilder.add((Component)this.selectedCaseType, new CellConstraints(3, 3, 1, 1, CellConstraints.LEFT, CellConstraints.BOTTOM, new Insets(5, 5, 0, 0)));
        JLabel priorityLabel = leftBuilder.getComponentFactory().createLabel(i18n.text(WorkspaceResources.priority_label, new Object[0]));
        priorityLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        leftBuilder.add((Component)priorityLabel, new CellConstraints(4, 3, 1, 1, CellConstraints.FILL, CellConstraints.BOTTOM, new Insets(4, 0, 0, 0)));
        leftBuilder.nextLine();
        javax.swing.Action labelAction = this.labels.getActionMap().get("addLabel");
        this.labelButton = new StreamflowButton(labelAction);
        this.labelButton.registerKeyboardAction(labelAction, (KeyStroke)labelAction.getValue("AcceleratorKey"), 2);
        this.labelButton.setHorizontalAlignment(2);
        this.labels.setButtonRelation(this.labelButton);
        refreshLabelComponents.enabledOn("addlabel", this.labelButton, this.labels);
        leftBuilder.add((Component)this.labelButton, new CellConstraints(1, 4, 1, 1, CellConstraints.FILL, CellConstraints.TOP, new Insets(5, 0, 0, 0)));
        this.labels.setPreferredSize(new Dimension(500, 50));
        leftBuilder.add((Component)this.labels, new CellConstraints(3, 4, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(5, 0, 0, 0)));
        JPanel prioPanel = new JPanel(new BorderLayout());
        this.casePriority = (JComboBox)BindingFormBuilder.Fields.COMBOBOX.newField();
        prioPanel.add(this.valueBinder.bind("priority", this.actionBinder.bind("changePriority", this.casePriority)));
        leftBuilder.add((Component)prioPanel, new CellConstraints(4, 4, 1, 1, CellConstraints.FILL, CellConstraints.TOP, new Insets(2, 0, 0, 0)));
        priorityLabel.setLabelFor(this.casePriority);
        refreshComponents.visibleOn("changepriority", this.casePriority, priorityLabel);
        refreshComponents.enabledOn("changepriority", this.casePriority, priorityLabel);
        this.casePriority.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                final PriorityValue itemValue = (PriorityValue)value;
                String val = itemValue == null ? "" : (String)itemValue.text().get();
                JPanel panel = new JPanel();
                panel.setOpaque(false);
                FormLayout layout = new FormLayout("10dlu, 60dlu:grow", "pref");
                DefaultFormBuilder formBuilder = new DefaultFormBuilder(layout, panel);
                panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 1, 0));
                JLabel label = new JLabel(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void paintComponent(Graphics g) {
                        Color color = this.getBackground();
                        if (itemValue != null) {
                            color = !Strings.empty((String)((String)itemValue.color().get())) ? new Color(Integer.parseInt((String)itemValue.color().get())) : Color.BLACK;
                        }
                        Color FILL_COLOR = ColorUtil.removeAlpha((Color)color);
                        Graphics2D g2 = (Graphics2D)g.create();
                        try {
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2.setColor(Color.LIGHT_GRAY);
                            int DIAM = Math.min(this.getWidth(), this.getHeight());
                            int inset = 3;
                            g2.fill(new Ellipse2D.Float(3.0f, 3.0f, DIAM - 6, DIAM - 6));
                            g2.setColor(FILL_COLOR);
                            boolean border = true;
                            g2.fill(new Ellipse2D.Float(4.0f, 4.0f, DIAM - 6 - 2, DIAM - 6 - 2));
                        }
                        finally {
                            g2.dispose();
                        }
                    }
                };
                label.setPreferredSize(new Dimension(10, 10));
                formBuilder.add((Component)(Strings.empty((String)val) || "-".equals(val) ? new JLabel() : label), new CellConstraints(1, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
                JLabel text = new JLabel(val);
                formBuilder.add((Component)text, new CellConstraints(2, 1, 1, 1, CellConstraints.LEFT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
                return panel;
            }
        });
        leftBuilder.nextLine();
        leftBuilder.add((Component)this.caseNotes, new CellConstraints(1, 6, 4, 1, CellConstraints.FILL, CellConstraints.TOP, new Insets(0, 2, 5, 0)));
        JLabel formsLabel = new JLabel(i18n.text(WorkspaceResources.forms_label, new Object[0]));
        refreshComponents.visibleOn("changedescription", formsLabel);
        leftBuilder.add((Component)formsLabel, new CellConstraints(1, 7, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(5, 0, 0, 0)));
        leftBuilder.nextLine();
        JPanel formsPanel = new JPanel(new BorderLayout());
        formsPanel.add((Component)this.forms, "West");
        leftBuilder.add((Component)formsPanel, new CellConstraints(1, 8, 3, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(5, 0, 0, 0)));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, 1);
        this.dueOnField.getMonthView().setLowerBound(calendar.getTime());
        final DateFormat dateFormat = DateFormat.getDateInstance(3);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dueOnField.getEditor().setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)new DatePickerFormatter(new DateFormat[]{dateFormat}){

            public Object stringToValue(String text) throws ParseException {
                Object result;
                try {
                    result = super.stringToValue(text);
                }
                catch (ParseException pe) {
                    CaseGeneralView.this.dialogs.showMessageDialog((Component)CaseGeneralView.this.dueOnField, i18n.text(WorkspaceResources.wrong_format_msg, new Object[0]) + " " + ((SimpleDateFormat)dateFormat).toPattern(), i18n.text(WorkspaceResources.wrong_format_title, new Object[0]));
                    throw pe;
                }
                return result;
            }
        }));
        JPanel formsContainer = new JPanel();
        formsContainer.setLayout(new GridLayout(1, 2));
        formsContainer.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        formsContainer.add(this.leftPane);
        formsContainer.add(caseLogView);
        this.setViewportView(formsContainer);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setFocusCycleRoot(true);
        this.setFocusable(true);
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.model.refresh();
        this.valueBinder.update((ValueComposite)this.model.getGeneral());
        this.selectedCaseType.setClickLink((LinkValue)this.model.getGeneral().caseType().get());
        if (this.model.getCommandEnabled("changepriority")) {
            EventComboBoxModel<PriorityValue> comboBoxModel = this.model.getCasePriorities();
            this.casePriority.setModel(comboBoxModel);
            LinkValue selectPriority = (LinkValue)this.model.getGeneral().priority().get();
            if (selectPriority != null) {
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    PriorityValue priorityValue = (PriorityValue)comboBoxModel.getElementAt(i);
                    if (priorityValue == null || !((String)priorityValue.id().get()).equals(selectPriority.id().get())) continue;
                    this.casePriority.setSelectedItem(comboBoxModel.getElementAt(i));
                    this.casePriority.setToolTipText((String)selectPriority.text().get());
                }
            }
        }
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeDescription(ActionEvent event) {
        Property description = this.model.getGeneral().description();
        String oldValue = (String)description.get();
        try {
            description.set((Object)this.descriptionField.getText());
            description.set((Object)oldValue);
        }
        catch (ConstraintViolationException cve) {
            int maxLength = ((MaxLength)description.metaInfo(MaxLength.class)).value();
            this.descriptionField.setText(this.descriptionField.getText().substring(0, maxLength));
            throw new RuntimeException(new MessageFormat(i18n.text(StreamflowResources.max_length, new Object[0])).format(new Object[]{maxLength}).toString());
        }
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseGeneralView.this.model.changeDescription(CaseGeneralView.this.descriptionField.getText());
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeDueOn(ActionEvent event) {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseGeneralView.this.model.changeDueOn(CaseGeneralView.this.dueOnField.getDate());
            }
        };
    }

    @Action
    public Task changeCaseType() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleCaseTypes(), new Integer(1)}).newInstance();
        dialog.setPreferredSize(new Dimension(400, 200));
        this.dialogs.showOkCancelHelpDialog(this.caseTypeButton, dialog, i18n.text(WorkspaceResources.choose_casetype, new Object[0]));
        this.caseTypeButton.requestFocusInWindow();
        if (dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                protected void command() throws Exception {
                    LinkValue selected = dialog.getSelectedLink();
                    CaseGeneralView.this.model.changeCaseType(selected);
                    String labelQuery = dialog.getFilterField().getText();
                    if (!"".equals(labelQuery) && ((String)selected.classes().get()).toLowerCase().indexOf(labelQuery.toLowerCase()) != -1) {
                        EventList<LinkValue> possibleLabels = CaseGeneralView.this.labels.getModel().getPossibleLabels();
                        for (LinkValue link : possibleLabels) {
                            if (!((String)link.text().get()).toLowerCase().contains(labelQuery.toLowerCase())) continue;
                            CaseGeneralView.this.labels.getModel().addLabel(link);
                        }
                    }
                }
            };
        }
        return null;
    }

    @Action
    public Task removeCaseType() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseGeneralView.this.model.removeCaseType();
            }
        };
    }

    @Action
    public Task changePriority() {
        String newPriority;
        final PriorityValue selected = (PriorityValue)this.casePriority.getSelectedItem();
        String oldPriority = this.model.getGeneral().priority().get() != null ? (String)((LinkValue)this.model.getGeneral().priority().get()).id().get() : "-1";
        String string = newPriority = selected != null ? (String)selected.id().get() : "-1";
        if (!newPriority.equals(oldPriority)) {
            return new CommandTask(){

                @Override
                protected void command() throws Exception {
                    CaseGeneralView.this.model.changePriority((String)selected.id().get());
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedLabel", "removedLabel", "changedOwner", "changedCaseType", "changedStatus", "changedPriority", "setUnread"}), transactions)) {
            this.refresh();
        }
    }
}

