/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import se.streamsource.streamflow.api.workspace.cases.conversation.ConversationDTO;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.DateFormats;
import se.streamsource.streamflow.client.util.i18n;

public class ConversationsListCellRenderer
implements ListCellRenderer {
    DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    public Component getListCellRendererComponent(final JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    list.setCellRenderer(new ConversationsListCellRenderer());
                }
            }
        });
        if (list instanceof JXList) {
            ((JXList)list).addHighlighter(HighlighterFactory.createAlternateStriping());
        }
        ConversationDTO conversation = (ConversationDTO)value;
        JPanel renderer = new JPanel(new BorderLayout());
        renderer.setLayout(new BorderLayout());
        renderer.setBorder(new EmptyBorder(3, 3, 3, 3));
        FormLayout headerLayout = new FormLayout("40dlu:grow, pref, 3dlu, pref", "pref");
        JPanel headerPanel = new JPanel((LayoutManager)headerLayout);
        headerPanel.setFocusable(false);
        DefaultFormBuilder headerBuilder = new DefaultFormBuilder(headerLayout, headerPanel);
        JLabel title = new JLabel((String)conversation.text().get());
        title.setFont(title.getFont().deriveFont(1));
        headerBuilder.add((Component)title);
        headerBuilder.nextColumn();
        JLabel participants = new JLabel(String.valueOf(conversation.participants().get()), i18n.icon(Icons.participants, 16), 10);
        headerBuilder.add((Component)participants);
        headerBuilder.nextColumn(2);
        JLabel conversationsLabel = new JLabel(String.valueOf(conversation.messages().get()), i18n.icon((Boolean)conversation.unread().get() != false ? Icons.unreadconversations : Icons.conversations, 16), 10);
        headerBuilder.add((Component)conversationsLabel);
        renderer.add((Component)headerPanel, "North");
        if (isSelected) {
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.setFocusable(false);
            JPanel ingressPanel = new JPanel(new FlowLayout(0));
            JLabel labelDate = new JLabel(DateFormats.getFullDateTimeValue((Date)conversation.creationDate().get(), Locale.getDefault()));
            labelDate.setFont(labelDate.getFont().deriveFont(2));
            ingressPanel.add(labelDate);
            JLabel labelCreator = new JLabel((String)conversation.creator().get());
            ingressPanel.add(labelCreator);
            contentPanel.add((Component)ingressPanel, "North");
            renderer.add((Component)contentPanel, "Center");
        } else {
            renderer.setPreferredSize(headerPanel.getPreferredSize());
            renderer.setBackground(Color.WHITE);
            headerPanel.setBackground(Color.WHITE);
        }
        if (list.getSelectedIndex() == index) {
            renderer.setPreferredSize(new Dimension(200, 40));
        } else {
            renderer.setPreferredSize(new Dimension(200, 20));
        }
        return renderer;
    }
}

