/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.caselog;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.workspace.cases.caselog.CaseLogEntryDTO;
import se.streamsource.streamflow.api.workspace.cases.caselog.CaseLogEntryTypes;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.caselog.CaseLogListCellRenderer;
import se.streamsource.streamflow.client.ui.workspace.cases.caselog.CaseLogModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowToggleButton;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.client.util.popup.PopupHandler;
import se.streamsource.streamflow.client.util.popup.RefreshHandler;
import se.streamsource.streamflow.client.util.popup.SelectionList;
import se.streamsource.streamflow.client.util.popup.StandardPopupHandler;
import se.streamsource.streamflow.client.util.popup.ValueToLabelConverter;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class CaseLogView
extends JPanel
implements TransactionListener,
Refreshable {
    private final CaseLogModel model;
    private JList filtersList;
    private JList list = new JXList(){

        public Object[] getSelectedValues() {
            int[] selectedIndexes = this.getSelectedIndices();
            Object[] selectedValues = new Object[selectedIndexes.length];
            for (int i = 0; i < selectedIndexes.length; ++i) {
                CaseLogEntryDTO link = (CaseLogEntryDTO)this.getElementAt(selectedIndexes[i]);
                selectedValues[i] = link.message().get();
            }
            return selectedValues;
        }
    };
    private JScrollPane newMessagePane;
    private JTextArea newMessageArea;
    private PopupHandler filterPopupHandler;
    private boolean editMode = false;
    private ListSelectionListener listSelectionListener;
    private JScrollPane scroll;
    private StreamflowToggleButton editButton;
    private ImageIcon notPublishedIcon;
    private ImageIcon publishedIcon;

    public CaseLogView(final @Service ApplicationContext context, @Uses CaseLogModel logmodel) {
        this.model = logmodel;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.notPublishedIcon = i18n.icon(Icons.not_published, 16);
        this.publishedIcon = i18n.icon(Icons.published, 16);
        FormLayout rightLayout = new FormLayout("30dlu, 300:grow, 50dlu, 20dlu", "pref, fill:pref:grow, 60dlu");
        this.setLayout((LayoutManager)rightLayout);
        this.setFocusable(false);
        DefaultFormBuilder rightBuilder = new DefaultFormBuilder(rightLayout, (JPanel)this);
        rightBuilder.setBorder(Borders.createEmptyBorder((ConstantSize)Sizes.DLUY2, (ConstantSize)Sizes.DLUX2, (ConstantSize)Sizes.DLUY2, (ConstantSize)Sizes.DLUX2));
        JLabel caseLogLabel = new JLabel(i18n.text(WorkspaceResources.case_log, new Object[0]));
        rightBuilder.add((Component)caseLogLabel, new CellConstraints(1, 1, 2, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        rightBuilder.nextColumn();
        this.filtersList = new SelectionList(Arrays.asList(CaseLogEntryTypes.system.name(), CaseLogEntryTypes.system_trace.name(), CaseLogEntryTypes.custom.name(), CaseLogEntryTypes.contact.name(), CaseLogEntryTypes.form.name(), CaseLogEntryTypes.conversation.name(), CaseLogEntryTypes.attachment.name()), this.model.getSelectedFilters(), new ValueToLabelConverter(){

            @Override
            public String convert(String value) {
                return i18n.text((Enum)CaseLogEntryTypes.valueOf((String)value.toString()), new Object[0]);
            }
        }, new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                String selectedValue;
                if (!event.getValueIsAdjusting() && (selectedValue = (String)((JList)event.getSource()).getSelectedValue()) != null) {
                    if (CaseLogView.this.model.getSelectedFilters().contains(selectedValue)) {
                        CaseLogView.this.model.getSelectedFilters().remove(selectedValue);
                    } else {
                        CaseLogView.this.model.getSelectedFilters().add(selectedValue);
                    }
                    CaseLogView.this.model.refresh();
                    ((JList)event.getSource()).clearSelection();
                }
            }
        });
        this.filterPopupHandler = new StandardPopupHandler(this, this.getActionMap().get("filter"), PopupHandler.Position.right, false, new RefreshHandler(){

            @Override
            public void refresh() {
                CaseLogView.this.model.refresh();
                CaseLogView.this.list.ensureIndexIsVisible(CaseLogView.this.list.getModel().getSize() - 1);
            }
        });
        rightBuilder.add((Component)this.filterPopupHandler.getButton(), new CellConstraints(3, 1, 1, 1, CellConstraints.RIGHT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this.filtersList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != null && e.getOppositeComponent().equals(CaseLogView.this.filterPopupHandler.getButton())) {
                    CaseLogView.this.filterPopupHandler.kill();
                }
            }
        });
        this.editButton = new StreamflowToggleButton(this.getActionMap().get("edit"));
        this.editButton.setMargin(new Insets(3, 7, 1, 5));
        rightBuilder.add((Component)this.editButton, new CellConstraints(4, 1, 1, 1, CellConstraints.RIGHT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        rightBuilder.nextLine();
        ((JXList)this.list).addHighlighter(HighlighterFactory.createAlternateStriping());
        this.list.setModel(new EventListModel(this.model.caselogs()));
        this.list.setCellRenderer(new CaseLogListCellRenderer());
        this.list.setFixedCellHeight(-1);
        this.list.getSelectionModel().setSelectionMode(0);
        final JList tmpList = this.list;
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int index = tmpList.locationToIndex(new Point(e.getX(), e.getY()));
                    if (tmpList.getSelectedIndex() != index) {
                        tmpList.setSelectedIndex(index);
                    }
                    final JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem();
                    item.setAction(context.getActionMap().get((Object)"copy"));
                    item.setIcon(null);
                    menu.add(item);
                    final int x = e.getX();
                    final int y = e.getY();
                    final Component c = e.getComponent();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            menu.show(c, x, y);
                        }
                    });
                }
            }
        });
        this.scroll = new JScrollPane(this.list, 20, 31);
        this.scroll.setMinimumSize(new Dimension(250, 100));
        this.scroll.setPreferredSize(new Dimension(400, 300));
        rightBuilder.setExtent(3, 1);
        rightBuilder.add((Component)this.scroll, new CellConstraints(1, 2, 4, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        ImageIcon icon = i18n.icon(Icons.message_add, 24);
        rightBuilder.add((Component)new JLabel(icon), new CellConstraints(1, 3, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(10, 10, 0, 0)));
        this.newMessageArea = new JTextArea(10, 30);
        this.newMessageArea.setLineWrap(true);
        this.newMessageArea.setWrapStyleWord(true);
        this.newMessagePane = new JScrollPane(this.newMessageArea);
        this.newMessagePane.setMinimumSize(new Dimension(10, 10));
        this.newMessagePane.setPreferredSize(new Dimension(10, 70));
        rightBuilder.add((Component)this.newMessagePane, new CellConstraints(2, 3, 3, 1, CellConstraints.FILL, CellConstraints.TOP, new Insets(10, 0, 0, 0)));
        this.newMessageArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && !e.isControlDown()) {
                    CaseLogView.this.newMessageArea.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (e.isControlDown()) {
                        CaseLogView.this.newMessageArea.append("\n");
                    } else {
                        CaseLogView.this.addMessage();
                    }
                }
            }
        });
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                CaseLogEntryDTO selectedValue;
                if (!event.getValueIsAdjusting() && (selectedValue = (CaseLogEntryDTO)((JList)event.getSource()).getSelectedValue()) != null) {
                    new CommandTask(){

                        @Override
                        protected void command() throws Exception {
                            CaseLogView.this.model.togglepublish((LinkValue)selectedValue);
                        }
                    }.execute();
                    ((JList)event.getSource()).clearSelection();
                }
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && !CaseLogView.this.isShowing() && CaseLogView.this.editMode) {
                    CaseLogView.this.editButton.setSelected(false);
                    CaseLogView.this.configureComponentsForEdit(false);
                }
            }
        });
        new RefreshWhenShowing(this, this);
    }

    @Action
    public void filter() {
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.setPreferredSize(new Dimension(130, 138));
        filterPanel.setMaximumSize(new Dimension(130, 138));
        filterPanel.setMaximumSize(new Dimension(130, 138));
        filterPanel.add((Component)this.filtersList, "Center");
        this.filterPopupHandler.setPanelContent(filterPanel);
    }

    @Action
    public void edit() {
        this.configureComponentsForEdit(!this.editMode);
    }

    private void configureComponentsForEdit(boolean edit) {
        this.editMode = edit;
        if (this.editMode) {
            this.editButton.setIcon(this.publishedIcon);
            this.scroll.setBorder(BorderFactory.createLineBorder(this.list.getSelectionBackground(), 2));
            this.list.addListSelectionListener(this.listSelectionListener);
        } else {
            this.editButton.setIcon(this.notPublishedIcon);
            this.scroll.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
            this.list.removeListSelectionListener(this.listSelectionListener);
        }
    }

    @Override
    public void refresh() {
        this.model.refresh();
        boolean isEditable = this.model.getCommandEnabled("addmessage");
        this.newMessagePane.getViewport().getView().setEnabled(isEditable);
        this.editButton.setEnabled(isEditable);
        if (!this.editMode) {
            this.list.ensureIndexIsVisible(this.list.getModel().getSize() - 1);
        }
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"delete"}), transactions)) {
            return;
        }
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedEntry", "modifiedMyPagesVisibility"}), transactions)) {
            this.refresh();
        }
    }

    public void addMessage() {
        if (!Strings.empty((String)this.newMessageArea.getText())) {
            this.model.addMessage(this.newMessageArea.getText());
            this.newMessageArea.setText("");
            this.newMessageArea.setCaretPosition(0);
            this.newMessageArea.requestFocusInWindow();
            this.refresh();
        }
    }
}

