/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import se.streamsource.streamflow.api.workspace.cases.CaseOutputConfigDTO;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.client.util.popup.SelectionList;
import se.streamsource.streamflow.client.util.popup.ValueToLabelConverter;

public class PdfPrintingDialog
extends JPanel {
    private JList options;
    private List<String> selected = new ArrayList<String>(Arrays.asList(CasePrintingOptions.contacts.name(), CasePrintingOptions.submittedForms.name(), CasePrintingOptions.conversations.name(), CasePrintingOptions.attachments.name()));
    private CaseOutputConfigDTO config;
    private JScrollPane pane = new JScrollPane();
    @Structure
    ValueBuilderFactory vbf;

    public PdfPrintingDialog(@Service ApplicationContext context) {
        this.setLayout(new BorderLayout());
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.getActionMap().put("close", this.getActionMap().get("cancel"));
        this.options = new SelectionList(Arrays.asList(CasePrintingOptions.contacts.name(), CasePrintingOptions.submittedForms.name(), CasePrintingOptions.conversations.name(), CasePrintingOptions.attachments.name(), CasePrintingOptions.caselog.name()), this.selected, new ValueToLabelConverter(){

            @Override
            public String convert(String value) {
                return i18n.text(CasePrintingOptions.valueOf(value.toString()), new Object[0]);
            }
        }, new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                String selectedValue;
                if (!event.getValueIsAdjusting() && (selectedValue = (String)((JList)event.getSource()).getSelectedValue()) != null) {
                    if (PdfPrintingDialog.this.selected.contains(selectedValue)) {
                        PdfPrintingDialog.this.selected.remove(selectedValue);
                    } else {
                        PdfPrintingDialog.this.selected.add(selectedValue);
                    }
                    ((SelectionList)event.getSource()).clearSelection();
                }
            }
        });
        this.pane.setViewportView(this.options);
        this.add((Component)this.pane, "Center");
        this.setPreferredSize(new Dimension(100, 110));
    }

    @Action
    public void execute() {
        ValueBuilder builder = this.vbf.newValueBuilder(CaseOutputConfigDTO.class);
        for (String s : this.selected) {
            switch (CasePrintingOptions.valueOf(s)) {
                case contacts: {
                    ((CaseOutputConfigDTO)builder.prototype()).contacts().set((Object)true);
                    break;
                }
                case conversations: {
                    ((CaseOutputConfigDTO)builder.prototype()).conversations().set((Object)true);
                    break;
                }
                case submittedForms: {
                    ((CaseOutputConfigDTO)builder.prototype()).submittedForms().set((Object)true);
                    break;
                }
                case attachments: {
                    ((CaseOutputConfigDTO)builder.prototype()).attachments().set((Object)true);
                    break;
                }
                case caselog: {
                    ((CaseOutputConfigDTO)builder.prototype()).caselog().set((Object)true);
                }
            }
        }
        this.config = (CaseOutputConfigDTO)builder.newInstance();
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public void cancel() {
        WindowUtils.findWindow((Component)this).dispose();
    }

    public CaseOutputConfigDTO getCaseOutputConfig() {
        return this.config;
    }

    public static enum CasePrintingOptions {
        contacts,
        submittedForms,
        conversations,
        attachments,
        caselog;

    }
}

