/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.io.Inputs;
import org.qi4j.api.io.Outputs;
import org.qi4j.api.structure.Module;
import org.restlet.representation.Representation;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.dci.value.link.TitledLinkValue;
import se.streamsource.streamflow.api.workspace.cases.CaseDTO;
import se.streamsource.streamflow.api.workspace.cases.CaseOutputConfigDTO;
import se.streamsource.streamflow.api.workspace.cases.general.PermissionsDTO;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.ui.workspace.cases.CasesModel;
import se.streamsource.streamflow.client.ui.workspace.cases.attachments.AttachmentsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.caselog.CaseLogModel;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.ContactsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.ConversationModel;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.ConversationsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.forms.CaseSubmittedFormsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseGeneralModel;

public class CaseModel
extends ResourceModel<CaseDTO> {
    @Structure
    Module module;
    @Uses
    CasesModel casesModel;

    @Override
    public void refresh() {
        super.refresh();
        CaseDTO caseDTO = (CaseDTO)this.getIndex();
    }

    public void open() {
        this.client.command("open");
    }

    public void assignToMe() {
        this.client.command("assign");
    }

    public void assignTo(LinkValue link) {
        this.client.postLink(link);
    }

    public void close() {
        this.client.command("close");
    }

    public void delete() {
        this.client.delete();
    }

    public void restrict() {
        this.client.command("restrict");
    }

    public void unrestrict() {
        this.client.command("unrestrict");
    }

    public EventList<TitledLinkValue> getPossibleAssignTo() {
        BasicEventList list = new BasicEventList();
        LinksValue linksValue = (LinksValue)this.client.query("possibleassignees", LinksValue.class);
        list.addAll((Collection)linksValue.links().get());
        return list;
    }

    public EventList<TitledLinkValue> getPossibleSendTo() {
        BasicEventList list = new BasicEventList();
        LinksValue linksValue = (LinksValue)this.client.query("possiblesendto", LinksValue.class);
        list.addAll((Collection)linksValue.links().get());
        return list;
    }

    public void sendTo(LinkValue linkValue) {
        this.client.postLink(linkValue);
    }

    public void reopen() {
        this.client.command("reopen");
    }

    public void unassign() {
        this.client.command("unassign");
    }

    public void onHold() {
        this.client.command("onhold");
    }

    public void resume() {
        this.client.command("resume");
    }

    public EventList<TitledLinkValue> getPossibleResolutions() {
        BasicEventList list = new BasicEventList();
        LinksValue linksValue = (LinksValue)this.client.query("possibleresolutions", LinksValue.class);
        list.addAll((Collection)linksValue.links().get());
        return list;
    }

    public void resolve(LinkValue linkValue) {
        this.client.postLink(linkValue);
    }

    public void formOnClose() {
        this.client.command("formonclose");
    }

    public void formOnRemove() {
        this.client.command("formondelete");
    }

    public PermissionsDTO permissions() {
        return (PermissionsDTO)this.client.query("permissions", PermissionsDTO.class);
    }

    public File export(CaseOutputConfigDTO config) throws IOException {
        Representation representation = (Representation)this.client.query("exportpdf", Representation.class, (Object)config);
        String name = representation.getDisposition().getFilename();
        String[] fileNameParts = name.split("\\.");
        File file = File.createTempFile(fileNameParts[0] + "_", "." + fileNameParts[1]);
        Inputs.byteBuffer((InputStream)representation.getStream(), (int)1024).transferTo(Outputs.byteBuffer((File)file));
        return file;
    }

    public void reinstate() {
        this.client.command("reinstate");
    }

    public void read() {
        this.client.postCommand("read");
    }

    public void markunread() {
        this.client.postCommand("markunread");
    }

    public void markread() {
        this.client.postCommand("markread");
    }

    public void requirecasetype() {
    }

    public CaseGeneralModel newGeneralModel() {
        return (CaseGeneralModel)this.module.objectBuilderFactory().newObjectBuilder(CaseGeneralModel.class).use(new Object[]{this.client.getSubClient("general")}).newInstance();
    }

    public CaseLogModel newCaseLogModel() {
        return (CaseLogModel)this.module.objectBuilderFactory().newObjectBuilder(CaseLogModel.class).use(new Object[]{this.client.getSubClient("caselog")}).newInstance();
    }

    public CaseSubmittedFormsModel newSubmittedFormsModel() {
        return (CaseSubmittedFormsModel)this.module.objectBuilderFactory().newObjectBuilder(CaseSubmittedFormsModel.class).use(new Object[]{this.client.getSubClient("submittedforms")}).newInstance();
    }

    public ContactsModel newContactsModel() {
        return (ContactsModel)this.module.objectBuilderFactory().newObjectBuilder(ContactsModel.class).use(new Object[]{this.client.getSubClient("contacts")}).newInstance();
    }

    public ConversationsModel newConversationsModel() {
        return (ConversationsModel)this.module.objectBuilderFactory().newObjectBuilder(ConversationsModel.class).use(new Object[]{this.client.getSubClient("conversations")}).newInstance();
    }

    public AttachmentsModel newAttachmentsModel() {
        return (AttachmentsModel)this.module.objectBuilderFactory().newObjectBuilder(AttachmentsModel.class).use(new Object[]{this.client.getSubClient("attachments")}).newInstance();
    }

    public ConversationModel newHistoryModel() {
        return (ConversationModel)this.module.objectBuilderFactory().newObjectBuilder(ConversationModel.class).use(new Object[]{this.client.getSubClient("history")}).newInstance();
    }
}

