/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventListModel;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.client.ui.ContextItem;
import se.streamsource.streamflow.client.ui.ContextItemGroupComparator;
import se.streamsource.streamflow.client.ui.ContextItemListRenderer;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceModel;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseModel;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.SeparatorContextItemListCellRenderer;
import se.streamsource.streamflow.util.Strings;

public class WorkspaceContextView
extends JPanel
implements Refreshable {
    private JList contextList;
    private JScrollPane workspaceContextScroll;
    private WorkspaceModel workspaceModel;

    public WorkspaceContextView(@Service ApplicationContext context, @Uses WorkspaceModel workspaceModel) {
        this.workspaceModel = workspaceModel;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(250, 500));
        this.contextList = new JList();
        ContextItemGroupComparator comparator = new ContextItemGroupComparator();
        JTextField filterField = new JTextField();
        SortedList sortedIssues = new SortedList(workspaceModel.getItems(), (Comparator)new Comparator<ContextItem>(){

            @Override
            public int compare(ContextItem o1, ContextItem o2) {
                return o1.getGroup().compareTo(o2.getGroup());
            }
        });
        FilterList textFilteredIssues = new FilterList((EventList)sortedIssues, (MatcherEditor)new TextComponentMatcherEditor((JTextComponent)filterField, (TextFilterator)new TextFilterator<ContextItem>(){

            public void getFilterStrings(List<String> strings, ContextItem contextItem) {
                if (Strings.empty((String)contextItem.getGroup())) {
                    strings.add(contextItem.getName());
                } else {
                    strings.add(contextItem.getGroup());
                }
            }
        }));
        SeparatorList separatorList = new SeparatorList((EventList)textFilteredIssues, (Comparator)comparator, 1, 10000);
        this.contextList.setModel(new EventListModel((EventList)separatorList));
        this.contextList.getSelectionModel().setSelectionMode(0);
        this.contextList.setCellRenderer(new SeparatorContextItemListCellRenderer((ListCellRenderer)((Object)new ContextItemListRenderer())));
        this.workspaceContextScroll = new JScrollPane(this.contextList);
        this.add((Component)filterField, "North");
        this.add((Component)this.workspaceContextScroll, "Center");
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.workspaceModel.refresh();
        new Task<Void, Void>(Application.getInstance()){

            protected Void doInBackground() throws Exception {
                WorkspaceContextView.this.workspaceModel.refreshCounts();
                return null;
            }
        }.execute();
    }

    public JList getWorkspaceContextList() {
        return this.contextList;
    }

    public boolean showContext(CaseModel caseModel) {
        boolean result = false;
        if (this.contextList.getSelectedValue() != null && ((ContextItem)this.contextList.getSelectedValue()).getRelation().equals("search")) {
            return result;
        }
        return result;
    }

    public WorkspaceModel getModel() {
        return this.workspaceModel;
    }
}

