/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.users;

import java.io.File;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.specification.Specifications;
import org.restlet.data.MediaType;
import org.restlet.representation.FileRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.api.administration.NewUserDTO;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ui.administration.users.UserAdministrationDetailModel;
import se.streamsource.streamflow.client.util.LinkValueListModel;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class UsersAdministrationListModel
extends LinkValueListModel
implements Refreshable {
    @Uses
    CommandQueryClient client;

    public UsersAdministrationListModel() {
        this.relationModelMapping("user", UserAdministrationDetailModel.class);
    }

    public void importUsers(File f) {
        MediaType type = f.getName().endsWith(".xls") ? MediaType.APPLICATION_EXCEL : MediaType.TEXT_CSV;
        FileRepresentation representation = new FileRepresentation(f, type);
        this.client.postCommand("importusers", (Object)representation);
    }

    public void createUser(NewUserDTO userDTO) {
        try {
            this.client.postCommand("createuser", (Object)userDTO);
        }
        catch (ResourceException e) {
            ErrorResources resources = ErrorResources.valueOf((String)e.getMessage());
            throw new OperationException((Enum)resources, (Throwable)e);
        }
    }

    @Override
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Specifications.or((Specification[])new Specification[]{Events.onEntities((String[])new String[]{this.client.getReference().getParentRef().getLastSegment()}), Events.onEntities((String[])new String[]{this.client.getReference().getLastSegment()}), Events.onEntities((String[])new String[]{"users"}), Specifications.and((Specification[])new Specification[]{Events.withNames((String[])new String[]{"createdUser", "changedDescription", "changedEnabled", "leftOrganization", "joinedOrganization"}), Events.onEntities((Iterable)this.linkValues)})}), transactions)) {
            this.refresh();
        }
    }
}

