/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.users;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.Property;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.interaction.profile.UserProfileDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactEmailDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactPhoneDTO;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.account.AccountResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.users.ResetPasswordDialog;
import se.streamsource.streamflow.client.ui.administration.users.UserAdministrationDetailModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.util.BindingFormBuilder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class UserAdministrationDetailView
extends JPanel
implements Observer,
TransactionListener {
    @Service
    DialogService dialogs;
    private Module module;
    @Service
    StreamflowApplication main;
    private StateBinder profileBinder;
    private StateBinder phoneNumberBinder;
    private StateBinder emailBinder;
    public JPanel profileForm;
    public JRadioButton noneButton;
    public JRadioButton emailButton;
    private UserAdministrationDetailModel model;
    private JPanel actionsPanel;
    private JPanel profilePanel;
    private DefaultFormBuilder actionsBuilder;
    private ApplicationContext context;

    public UserAdministrationDetailView(@Service ApplicationContext context, @Uses UserAdministrationDetailModel model, @Structure Module module) {
        this.model = model;
        this.context = context;
        this.module = module;
        model.addObserver(this);
        RefreshComponents refreshComponents = new RefreshComponents();
        model.addObserver(refreshComponents);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.actionsPanel = new JPanel();
        FormLayout actionsLayout = new FormLayout("pref", "pref, pref, pref, pref:grow, ");
        this.actionsPanel.setBorder(new EmptyBorder(new Insets(25, 0, 0, 0)));
        this.actionsBuilder = new DefaultFormBuilder(actionsLayout, this.actionsPanel);
        ActionMap am = this.getActionMap();
        this.profilePanel = new JPanel(new BorderLayout());
        this.profilePanel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.profileForm = new JPanel();
        this.profilePanel.add((Component)this.profileForm, "Center");
        FormLayout profileLayout = new FormLayout("85dlu, 5dlu, 120dlu:grow", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref");
        this.profileBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.profileBinder.setResourceMap(context.getResourceMap(this.getClass()));
        UserProfileDTO template = this.profileBinder.bindingTemplate(UserProfileDTO.class);
        this.phoneNumberBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.phoneNumberBinder.setResourceMap(context.getResourceMap(this.getClass()));
        ContactPhoneDTO phoneTemplate = this.phoneNumberBinder.bindingTemplate(ContactPhoneDTO.class);
        this.emailBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.emailBinder.setResourceMap(context.getResourceMap(this.getClass()));
        ContactEmailDTO emailTemplate = this.emailBinder.bindingTemplate(ContactEmailDTO.class);
        DefaultFormBuilder profileBuilder = new DefaultFormBuilder(profileLayout, this.profileForm);
        JLabel title = new JLabel(i18n.text(AccountResources.contact_info_for_user_separator, new Object[0]));
        title.setFont(title.getFont().deriveFont(1));
        profileBuilder.append((Component)title, 3);
        profileBuilder.nextLine();
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.name_label, new Object[0])));
        profileBuilder.nextColumn(2);
        JTextField nameTextField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
        profileBuilder.add((Component)this.profileBinder.bind(nameTextField, template.name()));
        profileBuilder.nextLine();
        refreshComponents.enabledOn("update", nameTextField);
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.email_label, new Object[0])));
        profileBuilder.nextColumn(2);
        JTextField emailTextField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
        profileBuilder.add((Component)this.emailBinder.bind(emailTextField, emailTemplate.emailAddress()));
        profileBuilder.nextLine();
        refreshComponents.enabledOn("update", emailTextField);
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.phone_label, new Object[0])));
        profileBuilder.nextColumn(2);
        JTextField phoneNumberTextField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
        profileBuilder.add((Component)this.phoneNumberBinder.bind(phoneNumberTextField, phoneTemplate.phoneNumber()));
        profileBuilder.nextLine(2);
        refreshComponents.enabledOn("update", phoneNumberTextField);
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.choose_message_delivery_type, new Object[0])));
        this.noneButton = (JRadioButton)BindingFormBuilder.Fields.RADIOBUTTON.newField();
        this.noneButton.setAction(am.get("messageDeliveryTypeNone"));
        this.noneButton.setSelected(true);
        profileBuilder.nextColumn(2);
        profileBuilder.add((Component)this.noneButton);
        profileBuilder.nextLine();
        profileBuilder.nextColumn(2);
        this.emailButton = (JRadioButton)BindingFormBuilder.Fields.RADIOBUTTON.newField();
        this.emailButton.setAction(am.get("messageDeliveryTypeEmail"));
        profileBuilder.add((Component)this.emailButton);
        refreshComponents.enabledOn("update", this.noneButton);
        refreshComponents.enabledOn("update", this.emailButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.noneButton);
        group.add(this.emailButton);
        profileBuilder.nextLine(2);
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.mark_read_timeout, new Object[0])));
        profileBuilder.nextColumn(2);
        profileBuilder.add(this.profileBinder.bind(BindingFormBuilder.Fields.TEXTFIELD.newField(), template.markReadTimeout()));
        profileBuilder.nextLine(2);
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.mail_footer, new Object[0])));
        profileBuilder.nextColumn(2);
        profileBuilder.add(this.profileBinder.bind(BindingFormBuilder.Fields.TEXTAREA.newField(), template.mailFooter()));
        profileBuilder.nextLine();
        this.profileBinder.addObserver(this);
        this.phoneNumberBinder.addObserver(this);
        this.emailBinder.addObserver(this);
        this.add((Component)this.profilePanel, "Center");
        this.add((Component)this.actionsPanel, "East");
        new RefreshWhenShowing(this, model);
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task setdisabled() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                UserAdministrationDetailView.this.model.setdisabled();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task setenabled() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                UserAdministrationDetailView.this.model.setenabled();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task join() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                UserAdministrationDetailView.this.model.join();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task leave() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setCustomMessage(i18n.text(AdministrationResources.leave_organization_confirmation, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    UserAdministrationDetailView.this.model.leave();
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task resetpassword() {
        final ResetPasswordDialog dialog = (ResetPasswordDialog)this.module.objectBuilderFactory().newObject(ResetPasswordDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.reset_password_title, new Object[0]));
        if (dialog.password() != null) {
            return new CommandTask(){

                @Override
                protected void command() throws Exception {
                    UserAdministrationDetailView.this.model.resetPassword(dialog.password());
                }
            };
        }
        return null;
    }

    @Action
    public void messageDeliveryTypeNone() throws Exception {
        this.model.changeMessageDeliveryType("none");
    }

    @Action
    public void messageDeliveryTypeEmail() throws Exception {
        this.model.changeMessageDeliveryType("email");
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"join", "leave", "setdisabled", "setenabled"}), transactions)) {
            this.model.refresh();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.actionsPanel.removeAll();
        this.actionsBuilder.setRow(1);
        this.actionsBuilder.setColumn(1);
        ActionMap am = this.getActionMap();
        for (UserAdministrationButtonTemplate buttonOrder : UserAdministrationButtonTemplate.values()) {
            for (LinkValue commandLink : Iterables.flatten((Iterable[])new Iterable[]{this.model.getCommands(), this.model.getQueries()})) {
                javax.swing.Action action1;
                if (!buttonOrder.toString().equals(commandLink.rel().get()) || (action1 = am.get(commandLink.rel().get())) == null) continue;
                StreamflowButton button = new StreamflowButton(action1);
                button.registerKeyboardAction(action1, (KeyStroke)action1.getValue("AcceleratorKey"), 2);
                button.setHorizontalAlignment(2);
                this.actionsBuilder.add((Component)button);
                this.actionsBuilder.nextLine();
                action1.putValue("sourceButton", button);
            }
        }
        if (o == this.model) {
            this.profileBinder.updateWith(this.model.getProfile());
            this.phoneNumberBinder.updateWith(this.model.getPhoneNumber());
            this.emailBinder.updateWith(this.model.getEmailAddress());
            String messageDeliveryType = this.model.getMessageDeliveryType();
            if ("email".equalsIgnoreCase(messageDeliveryType)) {
                this.emailButton.setSelected(true);
            } else {
                this.noneButton.setSelected(true);
            }
        } else {
            Property property = (Property)arg;
            if (property.qualifiedName().name().equals("name")) {
                try {
                    this.model.changeName((String)property.get());
                }
                catch (ResourceException e) {
                    throw new OperationException(CaseResources.could_not_change_name, (Throwable)e);
                }
            }
            if (property.qualifiedName().name().equals("phoneNumber")) {
                try {
                    this.model.changePhoneNumber((String)property.get());
                }
                catch (ResourceException e) {
                    throw new OperationException(CaseResources.could_not_change_phone_number, (Throwable)e);
                }
            }
            if (property.qualifiedName().name().equals("emailAddress")) {
                try {
                    this.model.changeEmailAddress((String)property.get());
                }
                catch (ResourceException e) {
                    throw new OperationException(CaseResources.could_not_change_email_address, (Throwable)e);
                }
            }
            if (property.qualifiedName().name().equals("markReadTimeout")) {
                try {
                    this.model.changeMarkReadTimeout((String)property.get());
                }
                catch (ResourceException e) {
                    throw new OperationException(CaseResources.could_not_change_mark_read_timeout, (Throwable)e);
                }
            }
            if (property.qualifiedName().name().equals("mailFooter")) {
                try {
                    this.model.changeMailFooter((String)property.get());
                }
                catch (ResourceException e) {
                    throw new OperationException(CaseResources.could_not_change_mark_read_timeout, (Throwable)e);
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    private static enum UserAdministrationButtonTemplate {
        setdisabled,
        setenabled,
        join,
        leave,
        resetpassword;

    }
}

