/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.templates;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collection;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.EntityValue;
import se.streamsource.dci.value.StringValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.administration.surface.SelectedTemplatesDTO;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.attachments.AttachmentsModel;
import se.streamsource.streamflow.client.util.Refreshable;

public class SelectedTemplatesModel
extends Observable
implements Refreshable {
    @Structure
    private Module module;
    private CommandQueryClient client;
    private SelectedTemplatesDTO DTO;

    public SelectedTemplatesModel(@Uses CommandQueryClient client) {
        this.client = client;
    }

    @Override
    public void refresh() {
        SelectedTemplatesDTO updatedDTO = (SelectedTemplatesDTO)this.client.query("selectedtemplates", SelectedTemplatesDTO.class);
        this.DTO = (SelectedTemplatesDTO)updatedDTO.buildWith().prototype();
        this.setChanged();
        this.notifyObservers();
    }

    public AttachmentsModel newAttachmentsModel() {
        return (AttachmentsModel)this.module.objectBuilderFactory().newObjectBuilder(AttachmentsModel.class).use(new Object[]{this.client.getClient("../attachments/")}).newInstance();
    }

    public EventList<LinkValue> getPossibleTemplates(String query) {
        try {
            BasicEventList list = new BasicEventList();
            ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(StringValue.class);
            ((StringValue)builder.prototype()).string().set((Object)"pdf");
            LinksValue listValue = (LinksValue)this.client.query(query, LinksValue.class, builder.newInstance());
            list.addAll((Collection)listValue.links().get());
            return list;
        }
        catch (ResourceException e) {
            throw new OperationException(WorkspaceResources.could_not_refresh, (Throwable)e);
        }
    }

    public void setTemplate(LinkValue link) {
        this.client.postLink(link);
    }

    public void removeTemplate(String command) {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(EntityValue.class);
        this.client.postCommand(command, builder.newInstance());
    }

    public SelectedTemplatesDTO getSelectedTemplatesValue() {
        return this.DTO;
    }
}

