/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.surface;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.EventJXTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.renderer.CheckBoxProvider;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.administration.ProxyUserDTO;
import se.streamsource.streamflow.client.ui.OptionsAction;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.surface.CreateProxyUserDialog;
import se.streamsource.streamflow.client.ui.administration.surface.ProxyUsersModel;
import se.streamsource.streamflow.client.ui.administration.users.ResetPasswordDialog;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class ProxyUsersView
extends JPanel
implements TransactionListener {
    private ProxyUsersModel model;
    @Structure
    Module module;
    @Service
    DialogService dialogs;
    JXTable proxyUsersTable;
    private EventJXTableModel<ProxyUserDTO> tableModel;

    public ProxyUsersView(@Service ApplicationContext context, @Uses ProxyUsersModel model) {
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.model = model;
        ProxyUsersTableFormat tableFormat = new ProxyUsersTableFormat();
        this.tableModel = new EventJXTableModel(model.getEventList(), (TableFormat)tableFormat);
        this.proxyUsersTable = new JXTable(this.tableModel);
        this.proxyUsersTable.getColumn(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((ComponentProvider)new CheckBoxProvider()));
        this.proxyUsersTable.getColumn(0).setMaxWidth(60);
        this.proxyUsersTable.getColumn(0).setResizable(false);
        this.proxyUsersTable.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get((Object)"resetPassword")));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView((Component)this.proxyUsersTable);
        super.setLayout(new BorderLayout());
        super.add((Component)scroll, "Center");
        JPopupMenu options = new JPopupMenu();
        options.add(am.get((Object)"resetPassword"));
        options.add(am.get((Object)"remove"));
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(am.get((Object)"add")));
        toolbar.add(new StreamflowButton(new OptionsAction(options)));
        super.add((Component)toolbar, "South");
        this.proxyUsersTable.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get((Object)"resetPassword"), am.get((Object)"remove")));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        final CreateProxyUserDialog dialog = (CreateProxyUserDialog)this.module.objectBuilderFactory().newObject(CreateProxyUserDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.create_user_title, new Object[0]));
        if (dialog.userCommand() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ProxyUsersView.this.model.createProxyUser(dialog.userCommand());
                }
            };
        }
        return null;
    }

    @Action
    public Task resetPassword() {
        final ResetPasswordDialog dialog = (ResetPasswordDialog)this.module.objectBuilderFactory().newObject(ResetPasswordDialog.class);
        final ProxyUserDTO proxyUser = (ProxyUserDTO)this.tableModel.getElementAt(this.proxyUsersTable.convertRowIndexToModel(this.proxyUsersTable.getSelectedRow()));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.reset_password_title, new Object[0]) + ": " + (String)proxyUser.description().get());
        if (dialog.password() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ProxyUsersView.this.model.resetPassword(proxyUser, dialog.password());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        final ProxyUserDTO proxyUser = (ProxyUserDTO)this.tableModel.getElementAt(this.proxyUsersTable.convertRowIndexToView(this.proxyUsersTable.getSelectedRow()));
        dialog.setRemovalMessage((String)proxyUser.description().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.remove_proxyuser_title, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ProxyUsersView.this.model.remove(proxyUser);
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"createdProxyUser", "changedEnabled"}), transactions)) {
            this.model.refresh();
        }
    }

    private class ProxyUsersTableFormat
    implements WritableTableFormat<ProxyUserDTO>,
    AdvancedTableFormat<ProxyUserDTO> {
        private ProxyUsersTableFormat() {
        }

        public boolean isEditable(ProxyUserDTO proxyUserDTO, int i) {
            return i == 0;
        }

        public ProxyUserDTO setColumnValue(final ProxyUserDTO proxyUserDTO, final Object o, int i) {
            new CommandTask(){

                @Override
                protected void command() throws Exception {
                    ProxyUsersView.this.model.changeEnabled(proxyUserDTO, (Boolean)o);
                }
            }.execute();
            return null;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int i) {
            return (new String[]{i18n.text(AdministrationResources.user_enabled_label, new Object[0]), i18n.text(AdministrationResources.username_label, new Object[0]), i18n.text(AdministrationResources.description_label, new Object[0])})[i];
        }

        public Class getColumnClass(int i) {
            return (new Class[]{Boolean.class, String.class, String.class})[i];
        }

        public Comparator getColumnComparator(int i) {
            return null;
        }

        public Object getColumnValue(ProxyUserDTO proxyUserDTO, int i) {
            switch (i) {
                case 0: {
                    return (Boolean)proxyUserDTO.disabled().get() == false;
                }
                case 1: {
                    return proxyUserDTO.username().get();
                }
                case 2: {
                    return proxyUserDTO.description().get();
                }
            }
            return null;
        }
    }
}

