/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.organizations;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.organizations.OrganizationUsersModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinksDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class OrganizationUsersView
extends JPanel
implements TransactionListener {
    @Structure
    Module module;
    @Service
    DialogService dialogs;
    public JList participantList;
    private OrganizationUsersModel model;
    public EventList<LinkValue> linkValues;

    public OrganizationUsersView(@Service ApplicationContext context, @Uses OrganizationUsersModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.linkValues = model.getList();
        this.participantList = new JList(new EventListModel(this.linkValues));
        this.participantList.setSelectionMode(0);
        this.participantList.setCellRenderer(new LinkListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.participantList);
        this.add((Component)scrollPane, "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(am.get("add")));
        toolbar.add(new StreamflowButton(am.get("remove")));
        this.add((Component)toolbar, "South");
        this.participantList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("remove")));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() throws ResourceException {
        SelectLinksDialog dialog = (SelectLinksDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinksDialog.class).use(new Object[]{this.model.getPossible()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), dialog, i18n.text(AdministrationResources.join_organization, new Object[0]));
        if (dialog.getSelectedLinks() != null) {
            final List links = (List)dialog.getSelectedLinks().links().get();
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    OrganizationUsersView.this.model.add(links);
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() throws ResourceException {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage(i18n.text(AdministrationResources.users_tab, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            final Iterable selected = Iterables.iterable((Object[])this.participantList.getSelectedValues());
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    for (LinkValue linkValue : selected) {
                        OrganizationUsersView.this.model.remove(linkValue);
                    }
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"joinedOrganization", "leftOrganization"}), transactions)) {
            this.model.refresh();
        }
    }
}

