/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.groups;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.ui.SelectUsersAndGroupsDialog;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.UsersAndGroupsModel;
import se.streamsource.streamflow.client.ui.administration.groups.ParticipantsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class ParticipantsView
extends JPanel
implements TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    public JList participantList;
    private ParticipantsModel model;

    public ParticipantsView(@Service ApplicationContext context, @Uses ParticipantsModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.participantList = new JList(new EventListModel(model.getList()));
        this.participantList.setCellRenderer(new LinkListCellRenderer());
        this.add((Component)new JScrollPane(this.participantList), "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(am.get("add")));
        toolbar.add(new StreamflowButton(am.get("remove")));
        this.add((Component)toolbar, "South");
        this.participantList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("remove")));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() throws ResourceException {
        UsersAndGroupsModel dialogModel = this.model.newUsersAndGroupsModel();
        SelectUsersAndGroupsDialog dialog = (SelectUsersAndGroupsDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectUsersAndGroupsDialog.class).use(new Object[]{dialogModel}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_user_or_group_title, new Object[0]));
        final Set<LinkValue> linkValueSet = dialog.getSelectedEntities();
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                ParticipantsView.this.model.add(linkValueSet);
            }
        };
    }

    @Action
    public Task remove() throws ResourceException {
        final Iterable selected = Iterables.iterable((Object[])this.participantList.getSelectedValues());
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                for (LinkValue linkValue : selected) {
                    ParticipantsView.this.model.remove(linkValue);
                }
            }
        };
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedParticipant", "removedParticipant"}), transactions) && !Events.matches((Specification)Events.withNames((String[])new String[]{"removedGroup"}), transactions)) {
            this.model.notifyTransactions(transactions);
        }
    }
}

