/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.filters;

import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Component;
import javax.swing.ActionMap;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.filters.LabelRuleModel;
import se.streamsource.streamflow.client.ui.administration.filters.LabelRuleView;
import se.streamsource.streamflow.client.ui.administration.filters.RulesModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.ListDetailView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class RulesView
extends ListDetailView {
    @Service
    private DialogService dialogs;
    @Structure
    private Module module;
    private RulesModel model;

    public RulesView(@Service ApplicationContext context, final @Structure Module module, final @Uses RulesModel model) {
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.initMaster((EventListModel<LinkValue>)new EventListModel(model.getList()), am.get("add"), new javax.swing.Action[]{am.get("remove")}, new ListDetailView.DetailFactory(){

            @Override
            public Component createDetail(LinkValue detailLink) {
                LabelRuleModel labelRuleModel = (LabelRuleModel)model.newResourceModel(detailLink);
                return (Component)module.objectBuilderFactory().newObjectBuilder(LabelRuleView.class).use(new Object[]{labelRuleModel}).newInstance();
            }
        });
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleLabels()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.choose_label_title, new Object[0]));
        if (dialog.getSelectedLinks() != null && dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    RulesView.this.model.createLabelRule(dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        final LinkValue linkValue = (LinkValue)this.list.getSelectedValue();
        dialog.setRemovalMessage((String)linkValue.text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                protected void command() throws Exception {
                    RulesView.this.model.remove(linkValue);
                }
            };
        }
        return null;
    }

    @Override
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"updatedFilter"}), transactions)) {
            this.model.refresh();
        }
    }
}

