/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.casesettings;

import ca.odell.glazedlists.swing.EventComboBoxModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.color.ColorUtil;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.FormValue;
import se.streamsource.streamflow.api.administration.priority.PriorityValue;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.casesettings.PriorityOnCaseModel;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class PriorityOnCaseView
extends JPanel
implements Observer,
TransactionListener {
    @Structure
    Module module;
    private PriorityOnCaseModel model;
    private final ApplicationContext context;
    private JCheckBox visible = new JCheckBox();
    private JCheckBox mandatory = new JCheckBox();
    private JComboBox defaultPriority = new JComboBox();

    public PriorityOnCaseView(@Service ApplicationContext context, @Uses PriorityOnCaseModel model) {
        this.context = context;
        this.model = model;
        this.model.addObserver(this);
        FormLayout layout = new FormLayout("150dlu, 2dlu, pref, pref:grow", "pref, pref, pref");
        this.setLayout((LayoutManager)layout);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.append(i18n.text(AdministrationResources.casepriority_visible, new Object[0]), (Component)this.visible);
        builder.append(i18n.text(AdministrationResources.casepriority_mandatory, new Object[0]), (Component)this.mandatory);
        builder.append(i18n.text(AdministrationResources.casepriority_default_value, new Object[0]), (Component)this.defaultPriority);
        this.defaultPriority.setRenderer(new LinkListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                final PriorityValue itemValue = (PriorityValue)value;
                String val = itemValue == null ? "" : (String)itemValue.text().get();
                JPanel panel = new JPanel(new FlowLayout(3, 2, 0));
                panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                JLabel label = new JLabel(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void paintComponent(Graphics g) {
                        Color color = this.getBackground();
                        if (itemValue != null && itemValue.color().get() != null) {
                            color = new Color(Integer.parseInt((String)itemValue.color().get()));
                        }
                        Color FILL_COLOR = ColorUtil.removeAlpha((Color)color);
                        Graphics2D g2 = (Graphics2D)g.create();
                        try {
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2.setColor(Color.LIGHT_GRAY);
                            int DIAM = Math.min(this.getWidth(), this.getHeight());
                            int inset = 3;
                            g2.fill(new Ellipse2D.Float(3.0f, 3.0f, DIAM - 6, DIAM - 6));
                            g2.setColor(FILL_COLOR);
                            boolean border = true;
                            g2.fill(new Ellipse2D.Float(4.0f, 4.0f, DIAM - 6 - 2, DIAM - 6 - 2));
                        }
                        finally {
                            g2.dispose();
                        }
                    }
                };
                label.setPreferredSize(new Dimension(20, 20));
                panel.add(Strings.empty((String)val) || "-".equals(val) ? new JLabel() : label);
                JLabel text = new JLabel(val);
                panel.add(text);
                panel.doLayout();
                return panel;
            }
        });
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        new ActionBinder((ActionMap)am).bind("updateVisibility", this.visible);
        new ActionBinder((ActionMap)am).bind("updateMandate", this.mandatory);
        new ActionBinder((ActionMap)am).bind("priorityDefault", this.defaultPriority);
        new RefreshWhenShowing(this, model);
    }

    @Override
    public void update(Observable o, Object arg) {
        FormValue prioritySettings = (FormValue)this.model.getIndex();
        this.visible.setSelected(Boolean.parseBoolean((String)((Map)prioritySettings.form().get()).get("visible")));
        this.mandatory.setSelected(Boolean.parseBoolean((String)((Map)prioritySettings.form().get()).get("mandatory")));
        this.mandatory.setEnabled(this.model.command("updatemandatory") != null);
        EventComboBoxModel<PriorityValue> comboBoxModel = this.model.getCasePriorities();
        this.defaultPriority.setModel(comboBoxModel);
        String selectPriority = (String)((Map)prioritySettings.form().get()).get("prioritydefault");
        if (!"".equals(selectPriority)) {
            for (int i = 1; i < comboBoxModel.getSize(); ++i) {
                PriorityValue priorityValue = (PriorityValue)comboBoxModel.getElementAt(i);
                if (!((String)priorityValue.id().get()).equals(selectPriority)) continue;
                this.defaultPriority.setSelectedItem(comboBoxModel.getElementAt(i));
            }
        }
    }

    @Action
    public Task updateVisibility() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PriorityOnCaseView.this.model.changeVisibility(PriorityOnCaseView.this.visible.isSelected());
            }
        };
    }

    @Action
    public Task updateMandate() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PriorityOnCaseView.this.model.changeMandate(PriorityOnCaseView.this.mandatory.isSelected());
            }
        };
    }

    @Action
    public Task priorityDefault() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PriorityOnCaseView.this.model.priorityDefault((String)((PriorityValue)PriorityOnCaseView.this.defaultPriority.getSelectedItem()).id().get());
            }
        };
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"updatevisibility"}), transactions)) {
            this.model.refresh();
        }
    }
}

