/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.casesettings;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.administration.ArchivalSettingsDTO;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.casesettings.CaseArchivalSettingModel;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class CaseArchivalSettingView
extends JPanel
implements Observer,
TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private CaseArchivalSettingModel model;
    private final ApplicationContext context;
    private JTextField maxAge = new JTextField(2);
    private JComboBox archivalType;

    public CaseArchivalSettingView(@Service ApplicationContext context, @Uses CaseArchivalSettingModel model) {
        this.context = context;
        this.model = model;
        model.addObserver(this);
        this.maxAge.setColumns(2);
        FormLayout layout = new FormLayout("150dlu, 2dlu, 50, 70", "pref, pref");
        this.setLayout((LayoutManager)layout);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.append(i18n.text(AdministrationResources.max_age, new Object[0]), (Component)this.maxAge);
        this.archivalType = new JComboBox<ArchivalSettingsDTO.ArchivalType>(new ArchivalSettingsDTO.ArchivalType[]{ArchivalSettingsDTO.ArchivalType.delete, ArchivalSettingsDTO.ArchivalType.export});
        this.archivalType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                ArchivalSettingsDTO.ArchivalType type = (ArchivalSettingsDTO.ArchivalType)o;
                return super.getListCellRendererComponent((JList<?>)jList, i18n.text(AdministrationResources.valueOf(type.toString()), new Object[0]), i, b, b1);
            }
        });
        builder.append(i18n.text(AdministrationResources.archival_type, new Object[0]), (Component)this.archivalType, 2);
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        new ActionBinder((ActionMap)am).bind("updateArchivalSettings", this.maxAge);
        new ActionBinder((ActionMap)am).bind("updateArchivalSettings", this.archivalType);
        new RefreshWhenShowing(this, model);
    }

    @Override
    public void update(Observable o, Object arg) {
        ArchivalSettingsDTO archivalSettings = (ArchivalSettingsDTO)this.model.getIndex();
        if (archivalSettings == null) {
            this.maxAge.setText("0");
            this.archivalType.setSelectedItem(ArchivalSettingsDTO.ArchivalType.delete);
        } else {
            this.maxAge.setText(((Integer)archivalSettings.maxAge().get()).toString());
            this.archivalType.setSelectedItem(archivalSettings.archivalType().get());
        }
    }

    @Action
    public void updateArchivalSettings() {
        this.model.changeArchivalSetting(Integer.parseInt(this.maxAge.getText()), (ArchivalSettingsDTO.ArchivalType)this.archivalType.getSelectedItem());
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.refresh();
    }
}

