/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration;

import java.awt.FlowLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.FormOnRemoveModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class FormOnRemoveView
extends JPanel
implements Observer,
TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private FormOnRemoveModel model;
    private final ApplicationContext context;
    private StreamflowButton formButton;
    private RemovableLabel selectedForm = new RemovableLabel();

    public FormOnRemoveView(@Service ApplicationContext context, @Uses FormOnRemoveModel model) {
        this.context = context;
        this.model = model;
        model.addObserver(this);
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.setLayout(new FlowLayout(0));
        javax.swing.Action formAction = this.getActionMap().get("form");
        this.formButton = new StreamflowButton(formAction);
        this.formButton.registerKeyboardAction(formAction, (KeyStroke)formAction.getValue("AcceleratorKey"), 2);
        this.formButton.setHorizontalAlignment(2);
        this.selectedForm.getButton().addActionListener(this.getActionMap().get("remove"));
        this.add(this.formButton);
        this.add(this.selectedForm);
        new RefreshWhenShowing(this, model);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.selectedForm.setRemoveLink((LinkValue)this.model.getIndex());
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.refresh();
    }

    @Action
    public void form() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleForms()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this.formButton, dialog, i18n.text(AdministrationResources.choose_form_on_remove, new Object[0]));
        new CommandTask(){

            @Override
            public void command() throws Exception {
                if (dialog.getSelectedLink() != null) {
                    FormOnRemoveView.this.model.changeFormOnRemove(dialog.getSelectedLink());
                }
            }
        }.execute();
    }

    @Action
    public void remove() {
        new CommandTask(){

            @Override
            protected void command() throws Exception {
                FormOnRemoveView.this.model.changeFormOnRemove(FormOnRemoveView.this.selectedForm.getRemoveLink());
            }
        }.execute();
    }
}

