/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration;

import ca.odell.glazedlists.TreeList;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.specification.Specifications;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.ui.administration.AdministrationModel;
import se.streamsource.streamflow.client.ui.administration.AdministrationTreeView;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.TabbedResourceView;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.EventParameters;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class AdministrationView
extends JPanel
implements TransactionListener {
    @Service
    StreamflowApplication application;
    JSplitPane mainView = new JSplitPane();
    JPanel detailView;
    CardLayout viewSwitch = new CardLayout();
    private ApplicationActionMap am;
    private AdministrationTreeView adminTreeView;
    private AdministrationModel model;

    public AdministrationView(@Service ApplicationContext context, final @Uses AdministrationModel model, final @Structure Module module) {
        this.am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)this.am);
        this.model = model;
        this.adminTreeView = (AdministrationTreeView)module.objectBuilderFactory().newObjectBuilder(AdministrationTreeView.class).use(new Object[]{this.model}).newInstance();
        this.setLayout(this.viewSwitch);
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.detailView = new JPanel(new BorderLayout());
        this.add((Component)this.mainView, "main");
        this.add((Component)this.detailView, "detail");
        this.viewSwitch.show(this, "main");
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(this.getMinimumSize());
        this.mainView.setBorder(BorderFactory.createEmptyBorder());
        this.mainView.setOneTouchExpandable(true);
        this.mainView.setLeftComponent(this.adminTreeView);
        this.adminTreeView.setMinimumSize(new Dimension(200, 400));
        this.mainView.setRightComponent(new JPanel());
        this.mainView.setDividerLocation(200);
        this.mainView.setResizeWeight(0.0);
        this.adminTreeView.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    Object node = path.getLastPathComponent();
                    LinkValue link = (LinkValue)((TreeList.Node)node).getElement();
                    if (Iterables.matchesAny((Specification)new Specification<String>(){

                        public boolean satisfiedBy(String item) {
                            return item.equals("disabled");
                        }
                    }, Arrays.asList(((String)link.classes().get()).split(" ")))) {
                        AdministrationView.this.mainView.setRightComponent(new JPanel());
                        return;
                    }
                    Object linkedModel = model.newResourceModel(link);
                    JComponent view = (JComponent)module.objectBuilderFactory().newObjectBuilder(TabbedResourceView.class).use(new Object[]{linkedModel}).newInstance();
                    AdministrationView.this.mainView.setRightComponent(view);
                }
            }
        });
    }

    public void show(JComponent view) {
        this.detailView.removeAll();
        this.detailView.add((Component)view, "Center");
        this.detailView.add((Component)new StreamflowButton(this.am.get((Object)"done")), "South");
        this.detailView.revalidate();
        this.detailView.repaint();
        this.viewSwitch.show(this, "detail");
    }

    @Action
    public void done() {
        this.viewSwitch.show(this, "main");
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Specifications.and((Specification[])new Specification[]{Events.withUsecases((String[])new String[]{"delete"}), Events.withNames((String[])new String[]{"revokedRole"})}), transactions)) {
            DomainEvent event = (DomainEvent)Iterables.first((Iterable)Iterables.filter((Specification)Specifications.and((Specification[])new Specification[]{Events.withUsecases((String[])new String[]{"delete"}), Events.withNames((String[])new String[]{"revokedRole"})}), (Iterable)Events.events(transactions)));
            if (Events.matches((Specification)Events.paramIs((String)"param1", (String)this.application.currentUserId()), transactions) || this.model.isParticipantInGroup(EventParameters.getParameter((DomainEvent)event, (String)"param1"), this.application.currentUserId())) {
                this.adminTreeView.getTree().setSelectionPath(null);
                this.model.notifyTransactions(transactions);
                this.mainView.setRightComponent(new JPanel());
            }
        }
    }
}

