/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import javax.swing.DefaultListSelectionModel;

public class VetoableListSelectionModel
extends DefaultListSelectionModel {
    private VetoableChangeSupport vetoableChangeSupport;

    public VetoableListSelectionModel() {
        this.setSelectionMode(0);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    private void fireVetoableChange(int oldSelectionIndex, int newSelectionIndex) throws PropertyVetoException {
        if (!this.isVetoable()) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange("selectedIndex", oldSelectionIndex, newSelectionIndex);
    }

    private boolean isVetoable() {
        return this.vetoableChangeSupport != null && this.getSelectionMode() == 0 && this.vetoableChangeSupport.hasListeners(null);
    }

    @Override
    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        if (this.isVetoable()) {
            try {
                this.fireVetoableChange(this.getMinSelectionIndex(), -1);
            }
            catch (PropertyVetoException e) {
                return;
            }
        }
        super.clearSelection();
    }

    @Override
    public void moveLeadSelectionIndex(int leadIndex) {
        if (this.isVetoable()) {
            try {
                this.fireVetoableChange(this.getLeadSelectionIndex(), leadIndex);
            }
            catch (PropertyVetoException e) {
                return;
            }
        }
        super.moveLeadSelectionIndex(leadIndex);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (this.isSelectionEmpty() || this.invalidRange(index0, index1)) {
            return;
        }
        if (this.isVetoable() && this.inRange(index0, index1)) {
            try {
                this.fireVetoableChange(this.getMinSelectionIndex(), -1);
            }
            catch (PropertyVetoException e) {
                return;
            }
        }
        super.removeSelectionInterval(index0, index1);
    }

    private boolean inRange(int index0, int index1) {
        int clearMin = Math.min(index0, index1);
        int clearMax = Math.max(index0, index1);
        return this.getMinSelectionIndex() >= clearMin && this.getMinSelectionIndex() <= clearMax;
    }

    private boolean invalidRange(int index0, int index1) {
        return index0 == -1 || index1 == -1;
    }

    @Override
    public void setLeadSelectionIndex(int leadIndex) {
        if (this.isVetoable()) {
            try {
                this.fireVetoableChange(this.getLeadSelectionIndex(), leadIndex);
            }
            catch (PropertyVetoException e) {
                return;
            }
        }
        super.setLeadSelectionIndex(leadIndex);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (this.isVetoable()) {
            try {
                this.fireVetoableChange(this.getMinSelectionIndex(), index0);
            }
            catch (PropertyVetoException e) {
                return;
            }
        }
        super.setSelectionInterval(index0, index1);
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        if (0 == this.getSelectionMode() && this.isSelectedIndex(index) && before) {
            this.setSelectionInterval(index + length, index + length);
        } else {
            super.insertIndexInterval(index, length, before);
        }
    }
}

