/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransactionList;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.domain.individual.Account;
import se.streamsource.streamflow.client.domain.individual.AccountSettingsValue;
import se.streamsource.streamflow.client.domain.individual.AccountVisitor;
import se.streamsource.streamflow.client.domain.individual.IndividualRepository;
import se.streamsource.streamflow.client.ui.account.AccountModel;
import se.streamsource.streamflow.client.util.LinkComparator;
import se.streamsource.streamflow.client.util.WeakModelMap;

public class AccountsModel {
    @Structure
    Module module;
    @Service
    IndividualRepository repository;
    TransactionList<LinkValue> accounts = new TransactionList((EventList)new SortedList((EventList)new BasicEventList(), (Comparator)new LinkComparator()));
    WeakModelMap<String, AccountModel> models = new WeakModelMap<String, AccountModel>(){

        @Override
        protected AccountModel newModel(String key) {
            UnitOfWork uow = AccountsModel.this.module.unitOfWorkFactory().newUnitOfWork();
            Account acc = (Account)uow.get(Account.class, key);
            uow.discard();
            AccountModel accountModel = (AccountModel)AccountsModel.this.module.objectBuilderFactory().newObjectBuilder(AccountModel.class).use(new Object[]{acc}).newInstance();
            accountModel.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    AccountsModel.this.refresh();
                }
            });
            return accountModel;
        }
    };

    public void init(@Service IndividualRepository repository) {
        this.refresh();
    }

    public EventList<LinkValue> getAccounts() {
        return this.accounts;
    }

    public AccountModel accountModel(LinkValue accountLink) {
        return this.models.get((String)accountLink.id().get());
    }

    public void newAccount(AccountSettingsValue accountSettingsValue) throws UnitOfWorkCompletionException, ResourceException {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        this.repository.individual().newAccount(accountSettingsValue);
        uow.complete();
        this.refresh();
    }

    public void removeAccount(LinkValue account) throws UnitOfWorkCompletionException {
        this.accountModel(account).remove();
        this.accounts.remove((Object)account);
    }

    private void refresh() {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        final ValueBuilder itemBuilder = this.module.valueBuilderFactory().newValueBuilder(LinkValue.class);
        this.accounts.beginEvent();
        this.accounts.clear();
        this.repository.individual().visitAccounts(new AccountVisitor(){

            @Override
            public void visitAccount(Account account) {
                ((LinkValue)itemBuilder.prototype()).text().set(account.accountSettings().name().get());
                ((LinkValue)itemBuilder.prototype()).href().set((Object)"");
                ((LinkValue)itemBuilder.prototype()).id().set((Object)account.toString());
                AccountsModel.this.accounts.add(itemBuilder.newInstance());
            }
        });
        uow.discard();
        this.accounts.commitEvent();
    }
}

