/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.account.AccountModel;
import se.streamsource.streamflow.client.ui.account.AccountResources;
import se.streamsource.streamflow.client.ui.account.AccountView;
import se.streamsource.streamflow.client.ui.account.AccountsModel;
import se.streamsource.streamflow.client.ui.account.CreateAccountDialog;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class AccountsDialog
extends JPanel
implements ListEventListener {
    AccountsModel model;
    @Structure
    Module module;
    @Service
    DialogService dialogs;
    public JList accountList;
    AccountView accountView;

    public AccountsDialog(@Service ApplicationContext context, final @Uses AccountsModel model) {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(700, 500));
        this.model = model;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.accountList = new JList(new EventListModel(model.getAccounts()));
        this.accountList.setCellRenderer(new LinkListCellRenderer());
        JPanel listPanel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.accountList);
        scroll.setMinimumSize(new Dimension(200, 300));
        scroll.setPreferredSize(new Dimension(200, 300));
        listPanel.add((Component)scroll, "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(this.getActionMap().get("add")));
        toolbar.add(new StreamflowButton(this.getActionMap().get("remove")));
        listPanel.add((Component)toolbar, "South");
        this.add((Component)listPanel, "West");
        final CardLayout cardLayout = new CardLayout();
        final JPanel viewPanel = new JPanel(cardLayout);
        viewPanel.add((Component)new JPanel(), "EMPTY");
        this.add((Component)viewPanel, "Center");
        this.accountList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(this.getActionMap().get("remove")));
        this.accountList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (AccountsDialog.this.accountList.getSelectedIndex() != -1) {
                        AccountModel account = model.accountModel((LinkValue)AccountsDialog.this.accountList.getSelectedValue());
                        AccountsDialog.this.accountView = (AccountView)AccountsDialog.this.module.objectBuilderFactory().newObjectBuilder(AccountView.class).use(new Object[]{account}).newInstance();
                        viewPanel.add((Component)AccountsDialog.this.accountView, "VIEW");
                        cardLayout.show(viewPanel, "VIEW");
                    } else {
                        cardLayout.show(viewPanel, "EMPTY");
                    }
                    viewPanel.revalidate();
                }
            }
        });
    }

    @Action
    public void execute() {
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public void add() throws ResourceException, UnitOfWorkCompletionException {
        CreateAccountDialog dialog = (CreateAccountDialog)this.module.objectBuilderFactory().newObject(CreateAccountDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AccountResources.create_account_title, new Object[0]));
        if (dialog.settings() != null) {
            this.model.newAccount(dialog.settings());
            this.listChanged(null);
        }
    }

    @Action
    public void remove() throws UnitOfWorkCompletionException {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)((LinkValue)this.accountList.getSelectedValue()).text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            this.model.removeAccount((LinkValue)this.accountList.getSelectedValue());
            this.listChanged(null);
        }
    }

    public void listChanged(ListEvent listEvent) {
        int prevSelected = this.accountList.getSelectedIndex();
        this.accountList.setModel(new EventListModel(this.model.accounts));
        this.accountList.repaint();
        this.accountList.setSelectedIndex(prevSelected);
    }

    public void setSelectedAccount(LinkValue selectedValue) {
        this.accountList.setSelectedValue(selectedValue, true);
    }
}

