/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.domain.individual;

import java.io.IOException;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.ClientCache;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.restlet.client.CommandQueryClientFactory;
import se.streamsource.dci.restlet.client.ResponseHandler;
import se.streamsource.streamflow.client.domain.individual.Account;
import se.streamsource.streamflow.client.domain.individual.AccountConnection;
import se.streamsource.streamflow.client.domain.individual.AccountSettings;
import se.streamsource.streamflow.client.domain.individual.AccountSettingsValue;
import se.streamsource.streamflow.client.domain.individual.IndividualRepository;

@Mixins(value={Mixin.class})
public interface AccountEntity
extends Account,
EntityComposite {

    public static class AuthenticationFilter
    implements Uniform {
        private UnitOfWorkFactory uowf;
        private AccountSettings account;
        private final Uniform next;

        public AuthenticationFilter(UnitOfWorkFactory uowf, AccountSettings account, Uniform next) {
            this.uowf = uowf;
            this.account = account;
            this.next = next;
        }

        public void handle(Request request, Response response) {
            AccountSettingsValue settings;
            UnitOfWork uow = this.uowf.currentUnitOfWork();
            if (uow == null) {
                uow = this.uowf.newUnitOfWork();
                settings = ((AccountSettings)uow.get((Object)this.account)).accountSettings();
                uow.discard();
            } else {
                settings = ((AccountSettings)uow.get((Object)this.account)).accountSettings();
            }
            request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_BASIC, (String)settings.userName().get(), (String)settings.password().get()));
            this.next.handle(request, response);
        }
    }

    public static class Mixin
    implements AccountSettings,
    AccountConnection {
        @Structure
        Module module;
        @This
        Account account;
        @This
        Data state;
        @Service
        IndividualRepository repo;
        @Service
        ResponseHandler handler;

        @Override
        public AccountSettingsValue accountSettings() {
            return (AccountSettingsValue)this.state.settings().get();
        }

        @Override
        public void updateSettings(AccountSettingsValue newAccountSettings) {
            this.state.settings().set((Object)newAccountSettings);
        }

        @Override
        public void changePassword(Uniform client, String oldPassword, String newPassword) throws ResourceException {
            Form form = new Form();
            form.set("oldpassword", oldPassword);
            form.set("newpassword", newPassword);
            this.server(client).getSubClient("account").postCommand("changepassword", (Object)form);
            AccountSettingsValue settings = (AccountSettingsValue)((AccountSettingsValue)this.state.settings().get()).buildWith().prototype();
            settings.password().set((Object)newPassword);
            this.updateSettings(settings);
        }

        @Override
        public CommandQueryClient server(Uniform client) {
            AccountSettingsValue settings = this.accountSettings();
            Reference serverRef = new Reference((String)settings.server().get());
            serverRef.setPath("/streamflow/");
            AuthenticationFilter filter = new AuthenticationFilter(this.module.unitOfWorkFactory(), this.account, client);
            return ((CommandQueryClientFactory)this.module.objectBuilderFactory().newObjectBuilder(CommandQueryClientFactory.class).use(new Object[]{filter, this.handler, new ClientCache()}).newInstance()).newClient(serverRef);
        }

        @Override
        public CommandQueryClient user(Uniform client) {
            return this.server(client).getSubClient("users").getSubClient((String)this.accountSettings().userName().get());
        }

        @Override
        public String version(Uniform client) throws ResourceException, IOException {
            CommandQueryClient server = this.server(client);
            Representation in = (Representation)server.getClient("/streamflow/static/").query("version.html", Representation.class);
            String version = in.getText();
            return version;
        }
    }

    public static interface Data {
        public Property<AccountSettingsValue> settings();
    }
}

