/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util.table;

import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import se.streamsource.streamflow.client.util.table.SeparatorTableUI;

public class SeparatorTable
extends JXTable {
    private final Class separatorClass = SeparatorList.Separator.class;

    public SeparatorTable(EventTableModel model) {
        super((TableModel)model);
        this.setColumnSelectionAllowed(false);
        this.setUI(new SeparatorTableUI(this.separatorClass));
        this.getTableHeader().setReorderingAllowed(false);
        this.setSortable(false);
        this.setRowSorter(null);
        this.setSelectionMode(1);
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        EventTableModel model;
        Rectangle sRect = super.getCellRect(row, column, includeSpacing);
        if (row < 0 || column < 0 || this.getModel().getRowCount() <= row || this.getModel().getColumnCount() <= column) {
            return sRect;
        }
        int index = 0;
        int columnMargin = this.getColumnModel().getColumnMargin();
        Rectangle cellFrame = new Rectangle();
        int aCellHeight = this.rowHeight + this.rowMargin;
        cellFrame.y = row * aCellHeight;
        cellFrame.height = aCellHeight;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            cellFrame.width = aColumn.getWidth() + columnMargin;
            if (index == column) break;
            cellFrame.x += cellFrame.width;
            ++index;
        }
        if (this.separatorClass.isInstance((model = (EventTableModel)this.getModel()).getElementAt(row))) {
            while (enumeration.hasMoreElements()) {
                TableColumn aColumn = enumeration.nextElement();
                cellFrame.width += aColumn.getWidth() + columnMargin;
            }
        }
        if (!includeSpacing) {
            Dimension spacing = this.getIntercellSpacing();
            cellFrame.setBounds(cellFrame.x + spacing.width / 2, cellFrame.y + spacing.height / 2, cellFrame.width - spacing.width, cellFrame.height - spacing.height);
        }
        return cellFrame;
    }

    private int[] rowColumnAtPoint(Point point) {
        int[] retValue = new int[]{-1, -1};
        int row = point.y / (this.rowHeight + this.rowMargin);
        if (row < 0 || this.getModel().getRowCount() <= row) {
            return retValue;
        }
        int column = this.getColumnModel().getColumnIndexAtX(point.x);
        if (this.getModel().getRowCount() == 0) {
            return retValue;
        }
        if (this.separatorClass.isInstance(((EventTableModel)this.getModel()).getElementAt(row))) {
            column = 0;
        }
        return new int[]{row, column};
    }

    public int rowAtPoint(Point point) {
        return this.rowColumnAtPoint(point)[0];
    }

    public int columnAtPoint(Point point) {
        return this.rowColumnAtPoint(point)[1];
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent e) {
        int i;
        int firstIndex = e.getFirstIndex();
        int lastIndex = e.getLastIndex();
        if (firstIndex == -1 && lastIndex == -1) {
            this.repaint();
        }
        Rectangle dirtyRegion = this.getCellRect(firstIndex, 0, false);
        int numCoumns = this.getColumnCount();
        int index = firstIndex;
        for (i = 0; i < numCoumns; ++i) {
            dirtyRegion.add(this.getCellRect(index, i, false));
        }
        index = lastIndex;
        for (i = 0; i < numCoumns; ++i) {
            dirtyRegion.add(this.getCellRect(index, i, false));
        }
        this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
    }
}

