/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util.dialog;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.SortedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.TitledLinkValue;
import se.streamsource.streamflow.client.util.FilteredList;
import se.streamsource.streamflow.client.util.GroupedFilteredList;
import se.streamsource.streamflow.client.util.LinkComparator;

public class SelectLinkDialog
extends JPanel {
    private LinkValue selectedLink;
    private List<LinkValue> selectedLinks = new ArrayList<LinkValue>();
    private JList list;
    private JTextField filterField;

    public SelectLinkDialog(@Service ApplicationContext context, @Uses EventList<? extends LinkValue> links, @Optional @Uses Integer showFilterCount) {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(250, 200));
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.getActionMap().put("close", this.getActionMap().get("cancel"));
        if (Iterables.first(links) instanceof TitledLinkValue) {
            GroupedFilteredList list = new GroupedFilteredList();
            list.getList().setSelectionMode(0);
            list.setEventList(links);
            this.add(list);
            this.list = list.getList();
            this.filterField = list.getFilterField();
        } else {
            FilteredList list = new FilteredList();
            list.getList().setSelectionMode(0);
            SortedList sortedIssues = new SortedList(links, (Comparator)new LinkComparator());
            list.setEventList((EventList<LinkValue>)sortedIssues);
            this.add(list);
            this.list = list.getList();
            this.filterField = list.getFilterField();
        }
        if (links.size() < (showFilterCount == null ? 10 : showFilterCount)) {
            this.filterField.setVisible(false);
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    public JTextField getFilterField() {
        return this.filterField;
    }

    public LinkValue getSelectedLink() {
        return this.selectedLink;
    }

    public List<LinkValue> getSelectedLinks() {
        return this.selectedLinks;
    }

    @Action
    public void execute() {
        if (this.list.getSelectionMode() == 0) {
            this.selectedLink = (LinkValue)this.list.getSelectedValue();
        } else {
            for (Object link : this.list.getSelectedValues()) {
                if (link instanceof SeparatorList.Separator) continue;
                this.selectedLinks.add((LinkValue)link);
            }
        }
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public void cancel() {
        WindowUtils.findWindow((Component)this).dispose();
    }
}

