/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXDialog;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.PropertyInfo;
import org.qi4j.api.util.DateFunctions;
import org.qi4j.library.constraints.annotation.MaxLength;
import org.qi4j.runtime.composite.ConstraintsCheck;
import org.qi4j.runtime.property.PropertyInstance;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.StreetAddressSuggestTextField;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AttachmentFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.CheckboxesPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.ComboBoxPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.DatePanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.ListBoxPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.NumberPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.OpenSelectionPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.OptionButtonsPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.TextAreaFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.TextFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoLocationFieldPanel;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

@Deprecated
public class StateBinder
extends Observable {
    @Service
    DialogService dialogs;
    ResourceBundle errorMessages;
    Map<Class<? extends Component>, Binder> binders = new HashMap<Class<? extends Component>, Binder>();
    Set<Binding> bindings = new HashSet<Binding>();
    Set<Converter> converters = new HashSet<Converter>();

    public StateBinder() {
        DefaultBinder defaultBinder = new DefaultBinder(this);
        this.registerBinder(defaultBinder, AbstractFieldPanel.class, TextFieldPanel.class, GeoLocationFieldPanel.class, TextAreaFieldPanel.class, NumberPanel.class, CheckboxesPanel.class, OptionButtonsPanel.class, OpenSelectionPanel.class, ListBoxPanel.class, ComboBoxPanel.class, DatePanel.class, AttachmentFieldPanel.class, JLabel.class, JTextField.class, JTextArea.class, JScrollPane.class, JPasswordField.class, JCheckBox.class, JXDatePicker.class, JComboBox.class, RemovableLabel.class, StreetAddressSuggestTextField.class);
        this.errorMessages = ResourceBundle.getBundle(this.getClass().getName());
    }

    public void setResourceMap(final ResourceMap resourceMap) {
        this.errorMessages = new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return resourceMap.getString(key, new Object[0]);
            }

            @Override
            public Enumeration<String> getKeys() {
                return Collections.enumeration(resourceMap.keySet());
            }
        };
    }

    public void addConverter(Converter converter) {
        this.converters.add(converter);
    }

    public void registerBinder(Binder binder, Class<? extends Component> ... componentTypes) {
        for (Class<? extends Component> componentType : componentTypes) {
            this.binders.put(componentType, binder);
        }
    }

    public <T extends Component> T bind(T component, Property property) {
        Binding binding;
        Binder binder = this.binders.get(component.getClass());
        if (binder == null) {
            throw new IllegalArgumentException("No binder registered for component type:" + component.getClass().getSimpleName());
        }
        if (property instanceof BinderPropertyInstance) {
            BinderPropertyInstance binderProperty = (BinderPropertyInstance)property;
            binding = binder.bind(component, binderProperty.accessor());
        } else {
            binding = binder.bind(component, property);
        }
        this.bindings.add(binding);
        return component;
    }

    public <T> T updateWith(T source) {
        for (Binding binding : this.bindings) {
            binding.updateWith(source);
        }
        return source;
    }

    public void update() {
        for (Binding binding : this.bindings) {
            binding.update();
        }
    }

    public void handleException(Component component, Exception e) {
        component.requestFocus();
        if (e instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)((Object)e);
            String[] messages = cve.getLocalizedMessages(this.errorMessages);
            StringBuilder message = new StringBuilder("<html>");
            for (String s : messages) {
                message.append(s).append("<br/>");
            }
            message.append("</html>");
            JLabel messageLabel = new JLabel(message.toString());
            JOptionPane.showMessageDialog(component, messageLabel, this.errorMessages.getString("property_constraint_violation"), 0);
        } else {
            Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
    }

    public <T> T bindingTemplate(Class<T> mixinType) {
        return (T)Proxy.newProxyInstance(mixinType.getClassLoader(), new Class[]{mixinType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Property.class.isAssignableFrom(method.getReturnType())) {
                    return new BinderPropertyInstance(method, new GenericPropertyInfo(method), null, null);
                }
                return null;
            }
        });
    }

    public Component[] boundComponents() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Binding binding : this.bindings) {
            components.add(binding.component);
        }
        return components.toArray(new Component[components.size()]);
    }

    public static interface Converter {
        public Object toComponent(Object var1);

        public Object fromComponent(Object var1);
    }

    class PropertyInputVerifier
    extends InputVerifier {
        private Binding binding;
        IllegalArgumentException exception;

        PropertyInputVerifier(Binding binding) {
            this.binding = binding;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                Object value = null;
                if (input instanceof JTextComponent) {
                    value = ((JTextComponent)input).getText();
                } else if (input instanceof JXDatePicker) {
                    value = ((JXDatePicker)input).getDate();
                }
                this.binding.updateProperty(value);
                return true;
            }
            catch (IllegalArgumentException e) {
                this.exception = e;
                return false;
            }
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            boolean result = super.shouldYieldFocus(input);
            if (!result) {
                Window window = WindowUtils.findWindow((Component)input);
                StringBuilder message = new StringBuilder(i18n.text(AdministrationResources.invalid_value, new Object[0]));
                if (this.exception instanceof ConstraintViolationException) {
                    ConstraintViolationException ex = (ConstraintViolationException)((Object)this.exception);
                    String[] messages = ex.getLocalizedMessages(StateBinder.this.errorMessages);
                    message = new StringBuilder("<html>");
                    for (String s : messages) {
                        message.append("<p>").append(s).append("</p>");
                    }
                    message.append("</html>");
                }
                JLabel main = new JLabel(message.toString());
                JXDialog dialog = window instanceof Frame ? new JXDialog((Frame)window, (JComponent)main) : new JXDialog((Dialog)window, (JComponent)main);
                dialog.setModal(true);
                dialog.pack();
                dialog.setLocationRelativeTo((Component)SwingUtilities.windowForComponent(input));
                dialog.setVisible(true);
            }
            return result;
        }
    }

    private class DefaultBinder
    implements Binder {
        private StateBinder stateBinder;

        public DefaultBinder(StateBinder stateBinder2) {
            this.stateBinder = stateBinder2;
        }

        @Override
        public Binding bind(Component component, Object property) {
            final Binding binding = new Binding(this, component, property, this.stateBinder);
            if (component instanceof AbstractFieldPanel) {
                ((AbstractFieldPanel)component).setBinding(binding);
                return binding;
            }
            if (component instanceof JPasswordField) {
                final JPasswordField passwordField = (JPasswordField)component;
                passwordField.setInputVerifier(new PropertyInputVerifier(binding));
                passwordField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(passwordField);
                    }
                });
                return binding;
            }
            if (component instanceof JTextField) {
                final JTextField textField = (JTextField)component;
                textField.setInputVerifier(new PropertyInputVerifier(binding));
                textField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(textField);
                    }
                });
                if (binding.getConstraint(MaxLength.class) != null) {
                    final MaxLength maxLength = (MaxLength)binding.getConstraint(MaxLength.class);
                    textField.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            if (textField.getDocument().getLength() > maxLength.value()) {
                                StateBinder.this.dialogs.showMessageDialog(textField, new MessageFormat(i18n.text(StreamflowResources.max_length, new Object[0])).format(new Object[]{"" + maxLength.value()}).toString(), i18n.text(StreamflowResources.invalid_input, new Object[0]));
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            textField.setText(textField.getDocument().getText(0, maxLength.value()));
                                        }
                                        catch (BadLocationException badLocationException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                        }
                    });
                }
                return binding;
            }
            if (component instanceof JTextArea) {
                JTextArea textArea = (JTextArea)component;
                textArea.setInputVerifier(new PropertyInputVerifier(binding));
                return binding;
            }
            if (component instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)component;
                return this.bind(pane.getViewport().getView(), property);
            }
            if (component instanceof JCheckBox) {
                final JCheckBox checkBox = (JCheckBox)component;
                checkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        binding.updateProperty(checkBox.isSelected());
                    }
                });
                return binding;
            }
            if (component instanceof JLabel) {
                return binding;
            }
            if (component instanceof JXDatePicker) {
                JXDatePicker datePicker = (JXDatePicker)component;
                datePicker.setInputVerifier((InputVerifier)new PropertyInputVerifier(binding));
                datePicker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if ("date".equals(e.getPropertyName())) {
                            binding.updateProperty(e.getNewValue());
                        }
                    }
                });
                return binding;
            }
            if (component instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)component;
                comboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        binding.updateProperty(((JComboBox)actionEvent.getSource()).getSelectedItem());
                    }
                });
                return binding;
            }
            if (component instanceof RemovableLabel) {
                RemovableLabel removableLabel = (RemovableLabel)component;
                removableLabel.getButton().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        binding.updateProperty(null);
                    }
                });
                return binding;
            }
            if (component instanceof StreetAddressSuggestTextField) {
                StreetAddressSuggestTextField suggestTextfield = (StreetAddressSuggestTextField)component;
                suggestTextfield.setBinding(binding);
                return binding;
            }
            throw new IllegalArgumentException("Could not bind to component of type " + component.getClass().getName());
        }

        @Override
        public void updateComponent(Component component, Object value) {
            if (component instanceof AbstractFieldPanel) {
                AbstractFieldPanel panel = (AbstractFieldPanel)component;
                panel.setValue(value == null ? "" : value.toString());
            } else if (component instanceof JPasswordField) {
                JPasswordField passwordField = (JPasswordField)component;
                passwordField.setText(value == null ? "" : value.toString());
            } else if (component instanceof JTextComponent) {
                JTextComponent textField = (JTextComponent)component;
                String text = value == null ? "" : value.toString();
                textField.setText(text);
                textField.setCaretPosition(0);
            } else if (component instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)component;
                checkBox.setSelected((Boolean)value);
            } else if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                label.setText(value == null ? "" : value.toString());
            } else if (component instanceof JXDatePicker) {
                JXDatePicker datePicker = (JXDatePicker)component;
                if (value instanceof String) {
                    if (!((String)value).isEmpty()) {
                        datePicker.setDate(DateFunctions.fromString((String)((String)value)));
                    }
                } else {
                    datePicker.setDate((Date)value);
                }
            } else if (component instanceof JComboBox) {
                JComboBox box = (JComboBox)component;
                box.setSelectedItem(value);
            } else if (component instanceof RemovableLabel) {
                RemovableLabel removableLabel = (RemovableLabel)component;
                removableLabel.setText((String)value);
            } else if (component instanceof StreetAddressSuggestTextField) {
                StreetAddressSuggestTextField suggestField = (StreetAddressSuggestTextField)component;
                suggestField.getTextField().setText(value == null ? "" : value.toString());
            }
        }
    }

    public class Binding {
        private Binder binder;
        private Object source;
        private Component component;
        private Object property;
        private StateBinder stateBinder;

        Binding(Binder binder, Component component, Object property, StateBinder stateBinder) {
            this.binder = binder;
            this.component = component;
            this.property = property;
            this.stateBinder = stateBinder;
        }

        void updateWith(Object source) {
            this.source = source;
            this.update();
        }

        void update() {
            if (this.source == null) {
                return;
            }
            try {
                Object newValue = this.property().get();
                if (newValue != null) {
                    for (Converter converter : StateBinder.this.converters) {
                        Object convertedValue = converter.toComponent(newValue);
                        if (convertedValue == newValue) continue;
                        newValue = convertedValue;
                        break;
                    }
                }
                this.binder.updateComponent(this.component, newValue);
            }
            catch (Exception e) {
                this.stateBinder.handleException(this.component, e);
            }
        }

        public void updateProperty(Object newValue) throws IllegalArgumentException {
            Property<Object> objectProperty = this.property();
            if (objectProperty == null) {
                return;
            }
            if (newValue != null) {
                for (Converter converter : StateBinder.this.converters) {
                    Object convertedValue = converter.fromComponent(newValue);
                    if (convertedValue == newValue) continue;
                    newValue = convertedValue;
                    break;
                }
            }
            if (objectProperty.get() == null && newValue == null) {
                return;
            }
            if (objectProperty.get() != null && objectProperty.get().equals(newValue)) {
                return;
            }
            objectProperty.set(newValue);
            StateBinder.this.setChanged();
            StateBinder.this.notifyObservers(objectProperty);
        }

        Property<Object> property() {
            if (this.property instanceof Method) {
                try {
                    return (Property)((Method)this.property).invoke(this.source, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                return null;
            }
            return (Property)this.property;
        }

        public Object getConstraint(Class annotationClass) {
            if (this.property instanceof Method) {
                return ((Method)this.property).getAnnotation(annotationClass);
            }
            return ((Property)this.property).metaInfo(annotationClass);
        }
    }

    static interface Binder {
        public Binding bind(Component var1, Object var2);

        public void updateComponent(Component var1, Object var2);
    }

    private static class BinderPropertyInstance
    extends PropertyInstance {
        private Method accessor;

        public BinderPropertyInstance(Method accessor, GenericPropertyInfo genericPropertyInfo, Object o, ConstraintsCheck o1) {
            super((PropertyInfo)genericPropertyInfo, o, o1);
            this.accessor = accessor;
        }

        public Method accessor() {
            return this.accessor;
        }
    }
}

