/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import ca.odell.glazedlists.TransactionList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.FormOnRemoveView;
import se.streamsource.streamflow.client.ui.administration.casesettings.CaseAccessDefaultsView;
import se.streamsource.streamflow.client.ui.administration.casesettings.CaseArchivalSettingView;
import se.streamsource.streamflow.client.ui.administration.casesettings.CaseDefaultDaysToCompleteView;
import se.streamsource.streamflow.client.ui.administration.casesettings.FormOnCloseView;
import se.streamsource.streamflow.client.ui.administration.casesettings.PriorityOnCaseView;
import se.streamsource.streamflow.client.ui.administration.casetypes.CaseTypeDetailView;
import se.streamsource.streamflow.client.ui.administration.organisationsettings.MailRestrictionsView;
import se.streamsource.streamflow.client.ui.administration.projectsettings.CaseDueOnNotificationView;
import se.streamsource.streamflow.client.ui.administration.projectsettings.RequiresCaseTypeView;
import se.streamsource.streamflow.client.util.i18n;

public class SettingsResourceView
extends JPanel {
    private static final Map<String, Class<? extends JComponent>> views = new LinkedHashMap<String, Class<? extends JComponent>>();
    private static final Map<String, Enum> settingsNames = new LinkedHashMap<String, Enum>();

    private static void addSettings(String name, Enum tabName, Class<? extends JComponent> viewClass) {
        settingsNames.put(name, tabName);
        views.put(name, viewClass);
    }

    public SettingsResourceView(@Uses ResourceModel model, @Structure Module module) {
        this.setLayout(new BoxLayout(this, 1));
        model.refresh();
        TransactionList<LinkValue> resources = model.getResources();
        for (Map.Entry<String, Class<? extends JComponent>> stringClassEntry : views.entrySet()) {
            LinkValue linkedResource = (LinkValue)Iterables.first((Iterable)Iterables.filter((Specification)Links.withRel((String)stringClassEntry.getKey()), resources));
            if (linkedResource == null) continue;
            String separatorText = i18n.text(settingsNames.get(stringClassEntry.getKey()), new Object[0]);
            Class<? extends JComponent> tabClass = stringClassEntry.getValue();
            try {
                Object resourceModel = model.newResourceModel(linkedResource);
                JLabel jLabel = new JLabel(separatorText, 2);
                jLabel.setFont(jLabel.getFont().deriveFont(1));
                jLabel.setAlignmentX(0.0f);
                this.add(jLabel);
                JComponent view = (JComponent)module.objectBuilderFactory().newObjectBuilder(tabClass).use(new Object[]{resourceModel}).newInstance();
                view.setAlignmentX(0.0f);
                view.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
                this.add(view);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.add(Box.createVerticalGlue());
    }

    static {
        SettingsResourceView.addSettings("caseaccessdefaults", AdministrationResources.caseaccessdefaults_separator, CaseAccessDefaultsView.class);
        SettingsResourceView.addSettings("defaultdaystocomplete", AdministrationResources.default_days_to_complete_separator, CaseDefaultDaysToCompleteView.class);
        SettingsResourceView.addSettings("dueonnotification", AdministrationResources.dueon_notification_separator, CaseDueOnNotificationView.class);
        SettingsResourceView.addSettings("requirescasetype", AdministrationResources.requires_casetype_seperator, RequiresCaseTypeView.class);
        SettingsResourceView.addSettings("casetypedetail", AdministrationResources.detail_separator, CaseTypeDetailView.class);
        SettingsResourceView.addSettings("archival", AdministrationResources.archival_settings_separator, CaseArchivalSettingView.class);
        SettingsResourceView.addSettings("priorityoncase", AdministrationResources.casepriority_separator, PriorityOnCaseView.class);
        SettingsResourceView.addSettings("formonclose", AdministrationResources.formonclose_separator, FormOnCloseView.class);
        SettingsResourceView.addSettings("restrictions", AdministrationResources.restrictions_settings_separator, CaseAccessDefaultsView.class);
        SettingsResourceView.addSettings("mailrestrictions", AdministrationResources.mailrestrictions_separator, MailRestrictionsView.class);
        SettingsResourceView.addSettings("mailrestrictions", AdministrationResources.mailrestrictions_separator, MailRestrictionsView.class);
        SettingsResourceView.addSettings("formondelete", AdministrationResources.formondelete_separator, FormOnRemoveView.class);
    }
}

