/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import se.streamsource.streamflow.client.util.UIUtils;

public class NotificationGlassPane
extends JPanel
implements MouseListener,
ActionListener {
    private boolean installed = false;
    private Component previousGlassPane;
    private Timer timer;
    private int delay = 3000;
    private Action action;
    private JButton button;
    private JFrame frame;

    public static void install() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                JButton button;
                Action action;
                if (event instanceof MouseEvent && event.getID() == 501 && event.getSource() instanceof JButton && (action = (button = (JButton)event.getSource()).getAction()) != null && action.getValue("AcceleratorKey") != null) {
                    for (MouseListener mouseListener : button.getMouseListeners()) {
                        if (!(mouseListener instanceof NotificationGlassPane)) continue;
                        return;
                    }
                    NotificationGlassPane.registerButton(button);
                }
            }
        }, 16L);
    }

    public NotificationGlassPane(JButton aButton) {
        this.button = aButton;
        this.button.addMouseListener(this);
        this.frame = UIUtils.getActiveJFrame(this.button);
        this.setOpaque(false);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int aDelay) {
        this.delay = aDelay;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.action = this.button.getAction();
        this.repaint();
        if (!this.installed) {
            this.previousGlassPane = this.frame.getGlassPane();
            this.frame.setGlassPane(this);
            this.setVisible(true);
            this.installed = true;
        }
        if (this.timer == null) {
            this.timer = new Timer(this.delay, this);
        } else {
            this.timer.stop();
            this.timer.setDelay(this.delay);
        }
        this.timer.start();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.action = this.button.getAction();
        this.repaint();
        if (!this.installed) {
            this.previousGlassPane = this.frame.getGlassPane();
            this.frame.setGlassPane(this);
            this.setVisible(true);
            this.installed = true;
        }
        if (this.timer == null) {
            this.timer = new Timer(this.delay, this);
        } else {
            this.timer.stop();
            this.timer.setDelay(this.delay);
        }
        this.timer.start();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.timer.stop();
        this.installed = false;
        this.setVisible(false);
        this.frame.setGlassPane(this.previousGlassPane);
        this.previousGlassPane = null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int arc;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension size = this.getSize();
        Font font = g.getFont();
        int h = size.height;
        int w = size.width;
        if (size.width > 300) {
            font = font.deriveFont(0, 48.0f);
            arc = 20;
        } else if (size.width > 150) {
            font = font.deriveFont(0, 24.0f);
            arc = 10;
        } else {
            font = font.deriveFont(0, 12.0f);
            arc = 3;
        }
        KeyStroke stroke = (KeyStroke)this.action.getValue("AcceleratorKey");
        String text = stroke.toString();
        text = text + " (" + this.button.getText() + ")";
        text = text.replaceAll(" pressed", "");
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D stringBounds = metrics.getStringBounds(text, g);
        int preferredWidth = (int)stringBounds.getWidth() + metrics.getHeight();
        int preferredHeight = (int)stringBounds.getHeight() + metrics.getHeight();
        w = Math.min(preferredWidth, w);
        h = Math.min(preferredHeight, h);
        int x = (size.width - w) / 2;
        int y = (size.height - h) / 7;
        Color vColor = new Color(0, 0, 0, 150);
        g.setColor(vColor);
        g.fillRoundRect(x, y, w, h, arc, arc);
        g.setColor(Color.WHITE);
        x = (size.width - (int)stringBounds.getWidth()) / 2;
        y = size.height / 5 + (metrics.getAscent() - metrics.getDescent()) / 2;
        g.drawString(text, x, y);
    }

    public static void registerButton(JButton aButton) {
        new NotificationGlassPane(aButton);
    }
}

