/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class HtmlPanel
extends JEditorPane {
    public HtmlPanel(String html) {
        super("text/html", html);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(bodyRule);
        this.setOpaque(false);
        this.setBorder(null);
        this.setEditable(false);
        this.setFocusable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                block6: {
                    if (!e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) break block6;
                    if (e.getURL() == null) {
                        String action = e.getDescription();
                        for (Window window : Frame.getWindows()) {
                            if (!this.invokeAction(window, action)) continue;
                            return;
                        }
                    } else {
                        try {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (URISyntaxException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }

            private boolean invokeAction(Component component, String name) {
                JComponent jcomp;
                ActionMap am;
                Action action;
                if (!component.isShowing()) {
                    return false;
                }
                if (component instanceof JComponent && (action = (am = (jcomp = (JComponent)component).getActionMap()).get(name)) != null) {
                    action.actionPerformed(new ActionEvent(component, 1001, name));
                    return true;
                }
                if (component instanceof Container) {
                    Container container = (Container)component;
                    for (Component childComponent : container.getComponents()) {
                        if (!this.invokeAction(childComponent, name)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

