/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.TitledLinkValue;

public class FilterLinkListCellRenderer
extends DefaultListCellRenderer
implements DocumentListener {
    private String filterText = "";

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof LinkValue) {
            String val;
            LinkValue itemValue = (LinkValue)value;
            String string = val = itemValue == null ? "" : (String)itemValue.text().get();
            if (value instanceof TitledLinkValue) {
                if (((TitledLinkValue)value).classes().get() != null) {
                    String classes = ((String)((TitledLinkValue)value).classes().get()).trim();
                    StringTokenizer tokenizer = new StringTokenizer(classes, " ");
                    String matchedClasses = "";
                    while (tokenizer.hasMoreElements()) {
                        String token = (String)tokenizer.nextElement();
                        if (!token.toLowerCase().contains(this.filterText.toLowerCase())) continue;
                        matchedClasses = matchedClasses + token + " ";
                    }
                    val = matchedClasses.trim().equals("") ? "<html>&nbsp; " + val + "</html>" : "<html>&nbsp; " + val + " [" + matchedClasses.trim() + "]</html>";
                } else {
                    val = "<html>&nbsp;&nbsp; " + val + "</html>";
                }
            }
            return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            String oldValue = this.filterText;
            this.filterText = e.getDocument().getText(0, e.getDocument().getLength());
            this.firePropertyChange("text", oldValue, this.filterText);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            String oldValue = this.filterText;
            this.filterText = e.getDocument().getText(0, e.getDocument().getLength());
            this.firePropertyChange("text", oldValue, this.filterText);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

