/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import java.util.Collection;

public class EventListSynch {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, P extends T> EventList<P> synchronize(Collection<T> list, EventList<P> eventList) {
        eventList.getReadWriteLock().writeLock().lock();
        try {
            if (eventList instanceof TransactionList) {
                ((TransactionList)eventList).beginEvent();
            }
            if (list.size() == eventList.size()) {
                int idx = 0;
                for (T item : list) {
                    if (!item.equals(eventList.get(idx))) {
                        eventList.set(idx, item);
                    }
                    ++idx;
                }
            } else if (list.size() < eventList.size()) {
                eventList.clear();
                eventList.addAll(list);
            } else {
                int idx = 0;
                for (T item : list) {
                    if (idx < eventList.size()) {
                        if (!item.equals(eventList.get(idx))) {
                            eventList.set(idx, item);
                        }
                    } else {
                        eventList.add(item);
                    }
                    ++idx;
                }
            }
            if (eventList instanceof TransactionList) {
                ((TransactionList)eventList).commitEvent();
            }
        }
        finally {
            eventList.getReadWriteLock().writeLock().unlock();
        }
        return eventList;
    }
}

