/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import ca.odell.glazedlists.UniqueList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.dci.value.table.CellValue;
import se.streamsource.dci.value.table.ColumnValue;
import se.streamsource.dci.value.table.RowValue;
import se.streamsource.dci.value.table.TableQuery;
import se.streamsource.dci.value.table.TableValue;
import se.streamsource.streamflow.api.administration.priority.PriorityValue;
import se.streamsource.streamflow.api.workspace.PerspectiveDTO;
import se.streamsource.streamflow.api.workspace.cases.CaseStates;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseTableValue;
import se.streamsource.streamflow.client.ui.workspace.table.GroupBy;
import se.streamsource.streamflow.client.ui.workspace.table.Period;
import se.streamsource.streamflow.client.ui.workspace.table.PerspectivePeriodModel;
import se.streamsource.streamflow.client.ui.workspace.table.SortBy;
import se.streamsource.streamflow.client.ui.workspace.table.SortOrder;
import se.streamsource.streamflow.client.util.LinkComparator;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.util.Strings;

public class CasesTableModel
extends Observable
implements Refreshable {
    @Structure
    protected Module module;
    @Uses
    protected CommandQueryClient client;
    BasicEventList<LinkValue> possibleLabels = new BasicEventList();
    BasicEventList<LinkValue> possibleCaseTypes = new BasicEventList();
    BasicEventList<LinkValue> possibleAssignees = new BasicEventList();
    BasicEventList<LinkValue> possibleProjects = new BasicEventList();
    BasicEventList<LinkValue> possibleCreatedBy = new BasicEventList();
    List<String> selectedStatuses = new ArrayList<String>(Arrays.asList(WorkspaceResources.OPEN.name(), WorkspaceResources.ON_HOLD.name(), WorkspaceResources.CLOSED.name()));
    List<String> selectedCaseTypeIds = new ArrayList<String>();
    List<String> selectedLabelIds = new ArrayList<String>();
    List<String> selectedAssigneeIds = new ArrayList<String>();
    List<String> selectedProjectIds = new ArrayList<String>();
    List<String> selectedCreatedByIds = new ArrayList<String>();
    List<Integer> invisibleColumns = new ArrayList<Integer>();
    GroupBy groupBy = GroupBy.none;
    SortBy sortBy = SortBy.none;
    SortOrder sortOrder = SortOrder.asc;
    private PerspectivePeriodModel createdOnModel;
    private PerspectivePeriodModel dueOnModel;
    protected EventList<CaseTableValue> eventList = new TransactionList((EventList)new BasicEventList());

    public CasesTableModel(@Structure Module module) {
        this.module = module;
        this.createdOnModel = (PerspectivePeriodModel)module.objectBuilderFactory().newObjectBuilder(PerspectivePeriodModel.class).use(new Object[]{Period.none}).newInstance();
        this.dueOnModel = (PerspectivePeriodModel)module.objectBuilderFactory().newObjectBuilder(PerspectivePeriodModel.class).use(new Object[]{Period.none}).newInstance();
    }

    public EventList<CaseTableValue> getEventList() {
        return this.eventList;
    }

    public void search(String text) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(TableQuery.class);
        String queryString = "select *";
        String whereClause = this.addWhereClauseFromFilter();
        String sorting = this.addSortingFromFilter();
        if (!Strings.empty((String)whereClause)) {
            queryString = queryString + " where " + whereClause;
        }
        if (!Strings.empty((String)sorting)) {
            queryString = queryString + sorting;
        }
        ((TableQuery)builder.prototype()).tq().set((Object)queryString);
        TableQuery query = (TableQuery)builder.newInstance();
        TableValue table = (TableValue)this.client.query("cases", TableValue.class, (Object)query);
        List<CaseTableValue> caseTableValues = this.caseTableValues(table);
        this.eventList.getReadWriteLock().writeLock().lock();
        try {
            if (this.eventList instanceof TransactionList) {
                ((TransactionList)this.eventList).beginEvent();
            }
            this.eventList.clear();
            this.eventList.addAll(caseTableValues);
            if (this.eventList instanceof TransactionList) {
                ((TransactionList)this.eventList).commitEvent();
            }
        }
        finally {
            this.eventList.getReadWriteLock().writeLock().unlock();
        }
        this.setChanged();
        this.notifyObservers();
    }

    protected List<CaseTableValue> caseTableValues(TableValue table) {
        ArrayList<CaseTableValue> caseTableValues = new ArrayList<CaseTableValue>();
        for (RowValue row : (List)table.rows().get()) {
            ValueBuilder caseBuilder = this.module.valueBuilderFactory().newValueBuilder(CaseTableValue.class);
            CaseTableValue prototype = (CaseTableValue)caseBuilder.prototype();
            List cells = (List)row.c().get();
            for (int i = 0; i < ((List)table.cols().get()).size(); ++i) {
                ColumnValue columnValue = (ColumnValue)((List)table.cols().get()).get(i);
                CellValue cell = (CellValue)cells.get(i);
                if (((String)columnValue.id().get()).equals("assigned")) {
                    prototype.assignedTo().set(cell.f().get());
                    continue;
                }
                if (((String)columnValue.id().get()).equals("caseid")) {
                    prototype.caseId().set(cell.f().get());
                    continue;
                }
                if (((String)columnValue.id().get()).equals("casetype")) {
                    prototype.caseType().set(cell.f().get());
                    continue;
                }
                if (((String)columnValue.id().get()).equals("creator")) {
                    prototype.createdBy().set(cell.f().get());
                    continue;
                }
                if (((String)columnValue.id().get()).equals("created")) {
                    prototype.creationDate().set((Object)((Date)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("due")) {
                    prototype.dueOn().set((Object)((Date)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("description")) {
                    prototype.description().set(cell.f().get());
                    continue;
                }
                if (((String)columnValue.id().get()).equals("hasattachments")) {
                    prototype.hasAttachments().set((Object)((Boolean)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("hascontacts")) {
                    prototype.hasContacts().set((Object)((Boolean)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("hasconversations")) {
                    prototype.hasConversations().set((Object)((Boolean)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("hasunreadconversation")) {
                    prototype.hasUnreadConversation().set((Object)((Boolean)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("hassubmittedforms")) {
                    prototype.hasSubmittedForms().set((Object)((Boolean)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("hasunreadform")) {
                    prototype.hasUnreadForm().set((Object)((Boolean)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("labels")) {
                    String json = cell.v().get().toString();
                    prototype.labels().set(this.module.valueBuilderFactory().newValueFromJSON(LinksValue.class, json));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("owner")) {
                    prototype.owner().set(cell.f().get());
                    continue;
                }
                if (((String)columnValue.id().get()).equals("parent") && cell.v().get() != null) {
                    prototype.parentCase().set(this.module.valueBuilderFactory().newValueFromJSON(LinkValue.class, cell.v().get().toString()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("resolution")) {
                    prototype.resolution().set(cell.f().get());
                    continue;
                }
                if (((String)columnValue.id().get()).equals("status")) {
                    prototype.status().set((Object)CaseStates.valueOf((String)cell.v().get().toString()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("subcases")) {
                    prototype.subcases().set(this.module.valueBuilderFactory().newValueFromJSON(LinksValue.class, cell.v().get().toString()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("href")) {
                    prototype.href().set((Object)cell.v().get().toString());
                    continue;
                }
                if (((String)columnValue.id().get()).equals("removed")) {
                    prototype.removed().set((Object)((Boolean)cell.v().get()));
                    continue;
                }
                if (((String)columnValue.id().get()).equals("priority") && cell.v().get() != null) {
                    prototype.priority().set(this.module.valueBuilderFactory().newValueFromJSON(PriorityValue.class, cell.v().get().toString()));
                    continue;
                }
                if (!((String)columnValue.id().get()).equals("unread")) continue;
                prototype.unread().set((Object)((Boolean)cell.v().get()));
            }
            caseTableValues.add((CaseTableValue)caseBuilder.newInstance());
        }
        return caseTableValues;
    }

    public EventList<LinkValue> getPossibleLabels() {
        LinksValue labels = (LinksValue)this.client.query("possiblelabels", LinksValue.class);
        this.possibleLabels.clear();
        this.possibleLabels.addAll((Collection)labels.links().get());
        return new UniqueList(this.possibleLabels, (Comparator)new LinkComparator());
    }

    public BasicEventList<LinkValue> getPossibleCaseTypes() {
        LinksValue caseTypes = (LinksValue)this.client.query("possiblecasetypes", LinksValue.class);
        this.possibleCaseTypes.clear();
        this.possibleCaseTypes.addAll((Collection)caseTypes.links().get());
        return this.possibleCaseTypes;
    }

    public BasicEventList<LinkValue> getPossibleAssignees() {
        LinksValue assignees = (LinksValue)this.client.query("possibleassignees", LinksValue.class);
        this.possibleAssignees.clear();
        this.possibleAssignees.addAll((Collection)assignees.links().get());
        return this.possibleAssignees;
    }

    public BasicEventList<LinkValue> getPossibleProjects() {
        LinksValue projects = (LinksValue)this.client.query("possibleprojects", LinksValue.class);
        this.possibleProjects.clear();
        this.possibleProjects.addAll((Collection)projects.links().get());
        return this.possibleProjects;
    }

    public BasicEventList<LinkValue> getPossibleCreatedBy() {
        LinksValue createdby = (LinksValue)this.client.query("possiblecreatedby", LinksValue.class);
        this.possibleCreatedBy.clear();
        this.possibleCreatedBy.addAll((Collection)createdby.links().get());
        return this.possibleCreatedBy;
    }

    public List<String> getSelectedStatuses() {
        return this.selectedStatuses;
    }

    public List<String> getSelectedCaseTypes() {
        return this.selectedDescriptions(this.selectedCaseTypeIds, (List<LinkValue>)this.possibleCaseTypes);
    }

    public List<String> getSelectedCaseTypeIds() {
        return this.selectedCaseTypeIds;
    }

    public List<String> getSelectedLabels() {
        return this.selectedDescriptions(this.selectedLabelIds, (List<LinkValue>)this.possibleLabels);
    }

    public List<String> getSelectedLabelIds() {
        return this.selectedLabelIds;
    }

    public List<String> getSelectedAssignees() {
        return this.selectedDescriptions(this.selectedAssigneeIds, (List<LinkValue>)this.possibleAssignees);
    }

    public List<String> getSelectedAssigneeIds() {
        return this.selectedAssigneeIds;
    }

    public List<String> getSelectedProjects() {
        return this.selectedDescriptions(this.selectedProjectIds, (List<LinkValue>)this.possibleProjects);
    }

    public List<String> getSelectedProjectIds() {
        return this.selectedProjectIds;
    }

    public List<String> getSelectedCreatedBy() {
        return this.selectedDescriptions(this.selectedCreatedByIds, (List<LinkValue>)this.possibleCreatedBy);
    }

    public List<String> getSelectedCreatedByIds() {
        return this.selectedCreatedByIds;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public PerspectivePeriodModel getCreatedOnModel() {
        return this.createdOnModel;
    }

    public PerspectivePeriodModel getDueOnModel() {
        return this.dueOnModel;
    }

    public PerspectiveDTO getPerspective(String name, String query) {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(PerspectiveDTO.class);
        ((PerspectiveDTO)builder.prototype()).query().set((Object)query);
        ((PerspectiveDTO)builder.prototype()).name().set((Object)name);
        ((PerspectiveDTO)builder.prototype()).labels().set(this.selectedLabelIds);
        ((PerspectiveDTO)builder.prototype()).statuses().set(this.selectedStatuses);
        ((PerspectiveDTO)builder.prototype()).sortBy().set((Object)this.sortBy.name());
        ((PerspectiveDTO)builder.prototype()).sortOrder().set((Object)this.sortOrder.name());
        ((PerspectiveDTO)builder.prototype()).groupBy().set((Object)this.groupBy.name());
        ((PerspectiveDTO)builder.prototype()).assignees().set(this.selectedAssigneeIds);
        ((PerspectiveDTO)builder.prototype()).caseTypes().set(this.selectedCaseTypeIds);
        ((PerspectiveDTO)builder.prototype()).createdBy().set(this.selectedCreatedByIds);
        ((PerspectiveDTO)builder.prototype()).projects().set(this.selectedProjectIds);
        ((PerspectiveDTO)builder.prototype()).createdOnPeriod().set((Object)this.createdOnModel.getPeriod().name());
        ((PerspectiveDTO)builder.prototype()).createdOn().set((Object)this.createdOnModel.getDate());
        ((PerspectiveDTO)builder.prototype()).dueOnPeriod().set((Object)this.dueOnModel.getPeriod().name());
        ((PerspectiveDTO)builder.prototype()).dueOn().set((Object)this.dueOnModel.getDate());
        ((PerspectiveDTO)builder.prototype()).context().set((Object)this.client.getReference().toString());
        ((PerspectiveDTO)builder.prototype()).invisibleColumns().set(this.invisibleColumns);
        return (PerspectiveDTO)builder.newInstance();
    }

    public void clearFilter() {
        this.selectedStatuses = new ArrayList<String>();
        this.selectedCaseTypeIds = new ArrayList<String>();
        this.selectedLabelIds = new ArrayList<String>();
        this.selectedAssigneeIds = new ArrayList<String>();
        this.selectedProjectIds = new ArrayList<String>();
        this.selectedCreatedByIds = new ArrayList<String>();
        this.invisibleColumns = new ArrayList<Integer>();
        this.groupBy = GroupBy.none;
        this.sortBy = SortBy.none;
        this.sortOrder = SortOrder.asc;
        this.createdOnModel.setDate(null);
        this.createdOnModel.setPeriod(Period.none);
        this.dueOnModel.setDate(null);
        this.dueOnModel.setPeriod(Period.none);
    }

    public List<LinkValue> possibleFilterLinks() {
        return (List)this.client.query().queries().get();
    }

    public void setFilter(PerspectiveDTO perspectiveDTO) {
        perspectiveDTO = (PerspectiveDTO)this.module.valueBuilderFactory().newValueBuilder(PerspectiveDTO.class).withPrototype((Object)perspectiveDTO).prototype();
        this.selectedStatuses = (List)perspectiveDTO.statuses().get();
        this.selectedCaseTypeIds = (List)perspectiveDTO.caseTypes().get();
        this.selectedLabelIds = (List)perspectiveDTO.labels().get();
        this.selectedAssigneeIds = (List)perspectiveDTO.assignees().get();
        this.selectedProjectIds = (List)perspectiveDTO.projects().get();
        this.selectedCreatedByIds = (List)perspectiveDTO.createdBy().get();
        this.sortBy = SortBy.valueOf((String)perspectiveDTO.sortBy().get());
        this.sortOrder = SortOrder.valueOf((String)perspectiveDTO.sortOrder().get());
        this.groupBy = GroupBy.valueOf((String)perspectiveDTO.groupBy().get());
        this.createdOnModel.setPeriod(Period.valueOf((String)perspectiveDTO.createdOnPeriod().get()));
        this.createdOnModel.setDate((Date)perspectiveDTO.createdOn().get());
        this.dueOnModel.setPeriod(Period.valueOf((String)perspectiveDTO.dueOnPeriod().get()));
        this.dueOnModel.setDate((Date)perspectiveDTO.dueOn().get());
        this.invisibleColumns = (List)perspectiveDTO.invisibleColumns().get();
    }

    protected String addSortingFromFilter() {
        String sort = "";
        if (this.sortBy != SortBy.none) {
            sort = " order by " + this.sortBy.name() + " " + this.sortOrder.name();
        }
        return sort;
    }

    protected String addWhereClauseFromFilter() {
        String comma;
        String filter = "";
        if (!this.selectedStatuses.isEmpty()) {
            filter = filter + " status:";
            comma = "";
            for (String status : this.selectedStatuses) {
                filter = filter + comma + status;
                comma = ",";
            }
        }
        if (!this.selectedCaseTypeIds.isEmpty()) {
            filter = filter + " caseType:\"";
            comma = "";
            for (String caseType : this.selectedCaseTypeIds) {
                filter = filter + comma + caseType;
                comma = ",";
            }
            filter = filter + "\"";
        }
        if (!this.selectedLabelIds.isEmpty()) {
            filter = filter + " label:\"";
            comma = "";
            for (String label : this.selectedLabelIds) {
                filter = filter + comma + label;
                comma = ",";
            }
            filter = filter + "\"";
        }
        if (!this.selectedAssigneeIds.isEmpty()) {
            filter = filter + " assignedTo:\"";
            comma = "";
            for (String assignee : this.selectedAssigneeIds) {
                filter = filter + comma + assignee;
                comma = ",";
            }
            filter = filter + "\"";
        }
        if (!this.selectedProjectIds.isEmpty()) {
            filter = filter + " project:\"";
            comma = "";
            for (String project : this.selectedProjectIds) {
                filter = filter + comma + project;
                comma = ",";
            }
            filter = filter + "\"";
        }
        if (!this.selectedCreatedByIds.isEmpty()) {
            filter = filter + " createdBy:\"";
            comma = "";
            for (String createdBy : this.selectedCreatedByIds) {
                filter = filter + comma + createdBy;
                comma = ",";
            }
            filter = filter + "\"";
        }
        if (!Period.none.equals((Object)this.createdOnModel.getPeriod())) {
            filter = filter + " createdOn:" + this.createdOnModel.getSearchValue("yyyyMMdd", "-");
        }
        if (!Period.none.equals((Object)this.dueOnModel.getPeriod())) {
            filter = filter + " dueOn:" + this.dueOnModel.getSearchValue("yyyyMMdd", "-");
        }
        return filter;
    }

    private List<String> selectedDescriptions(List<String> selected, List<LinkValue> baseList) {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (String id : selected) {
            for (LinkValue link : baseList) {
                if (!((String)link.id().get()).equals(id)) continue;
                descriptions.add((String)link.text().get());
            }
        }
        return descriptions;
    }

    public List<Integer> getInvisibleColumns() {
        return this.invisibleColumns;
    }

    public void addInvisibleColumn(Integer index) {
        if (!this.invisibleColumns.contains(index)) {
            this.invisibleColumns.add(index);
        }
    }

    public void removeInvisibleColumn(Integer index) {
        this.invisibleColumns.remove(index);
    }

    public void createCase() {
        this.client.postCommand("createcase");
    }

    public boolean isCreateCaseEnabled() {
        return this.client.getReference().getLastSegment().equals("assignments") || this.client.getReference().getLastSegment().equals("drafts");
    }

    public boolean containsCaseWithPriority() {
        for (CaseTableValue value : this.getEventList()) {
            if (value.priority().get() == null) continue;
            return true;
        }
        return false;
    }
}

