/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.administration.priority.PriorityValue;
import se.streamsource.streamflow.api.workspace.cases.CaseStates;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseTableValue;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.util.Strings;

public class CasesTableFormatter
implements AdvancedTableFormat<Object> {
    protected String[] columnNames;
    protected Class[] columnClasses;
    StringBuilder description = new StringBuilder();

    public CasesTableFormatter() {
        this.columnNames = new String[]{i18n.text(WorkspaceResources.title_column_header, new Object[0]), i18n.text(WorkspaceResources.info_column_header, new Object[0]), i18n.text(WorkspaceResources.casetype_column_header, new Object[0]), i18n.text(WorkspaceResources.assignee_column_header, new Object[0]), i18n.text(WorkspaceResources.created_column_header, new Object[0]), i18n.text(WorkspaceResources.created_by_column_header, new Object[0]), i18n.text(WorkspaceResources.duedate_column_header, new Object[0]), i18n.text(WorkspaceResources.project_column_header, new Object[0]), i18n.text(WorkspaceResources.case_priority_header, new Object[0]), i18n.text(WorkspaceResources.case_status_header, new Object[0])};
        this.columnClasses = new Class[]{String.class, ArrayList.class, String.class, String.class, Date.class, String.class, Date.class, String.class, PriorityValue.class, CaseStates.class};
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    public Class getColumnClass(int i) {
        return this.columnClasses[i];
    }

    public Comparator getColumnComparator(int i) {
        return null;
    }

    public Object getColumnValue(Object value, int i) {
        if (value instanceof SeparatorList.Separator) {
            SeparatorList.Separator separator = (SeparatorList.Separator)value;
            return separator;
        }
        CaseTableValue caseValue = (CaseTableValue)value;
        switch (i) {
            case 0: {
                this.description.setLength(0);
                if (!Strings.empty((String)((String)caseValue.caseId().get()))) {
                    this.description.append("#").append(caseValue.caseId()).append(" ");
                }
                this.description.append((String)caseValue.description().get());
                List labels = (List)((LinksValue)caseValue.labels().get()).links().get();
                if (labels.size() > 0) {
                    this.description.append(" (");
                    String comma = "";
                    for (LinkValue label : labels) {
                        this.description.append(comma).append((String)label.text().get());
                        comma = ",";
                    }
                    this.description.append(")");
                }
                return this.description.toString();
            }
            case 1: {
                ArrayList<String> icons = new ArrayList<String>();
                icons.add((Boolean)caseValue.hasContacts().get() != false ? Icons.projects.toString() : "empty");
                icons.add((Boolean)caseValue.hasUnreadConversation().get() != false ? Icons.unreadconversations.toString() : ((Boolean)caseValue.hasConversations().get() != false ? Icons.conversations.toString() : "empty"));
                icons.add((Boolean)caseValue.hasUnreadForm().get() != false ? Icons.unreadforms.toString() : ((Boolean)caseValue.hasSubmittedForms().get() != false ? Icons.forms.toString() : "empty"));
                icons.add((Boolean)caseValue.hasAttachments().get() != false ? Icons.attachments.toString() : "empty");
                return icons;
            }
            case 2: {
                return caseValue.caseType().get() == null ? null : (String)caseValue.caseType().get() + (Strings.empty((String)((String)caseValue.resolution().get())) ? "" : "(" + (String)caseValue.resolution().get() + ")");
            }
            case 3: {
                return caseValue.assignedTo().get();
            }
            case 4: {
                return caseValue.creationDate().get();
            }
            case 5: {
                return caseValue.createdBy().get();
            }
            case 6: {
                return caseValue.dueOn().get();
            }
            case 7: {
                return caseValue.owner().get();
            }
            case 8: {
                return caseValue.priority().get();
            }
            case 9: {
                return caseValue.status().get();
            }
            case 10: {
                return caseValue.href().get();
            }
        }
        return null;
    }
}

