/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceView;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseDetailView;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseModel;
import se.streamsource.streamflow.client.ui.workspace.cases.CasesModel;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class CasesDetailView
extends JPanel
implements TransactionListener {
    @Structure
    Module module;
    @Uses
    private CasesModel casesModel;
    private CaseDetailView currentView = null;
    private CardLayout layout = new CardLayout();
    private JPanel casePanel = new JPanel(new BorderLayout());
    private CaseModel currentCase;

    public CasesDetailView(@Service ApplicationContext context) {
        this.setLayout(this.layout);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.add((Component)new JLabel(i18n.text(WorkspaceResources.choose_case, new Object[0]), 0), "blank");
        this.add((Component)this.casePanel, "detail");
        this.layout.show(this, "blank");
        this.setPreferredSize(new Dimension(this.getWidth(), 500));
    }

    public void show(CaseModel model) {
        int selectedTab = -1;
        if (this.currentCase == null || !this.currentCase.equals(model)) {
            if (this.currentView != null) {
                selectedTab = this.currentView.getSelectedTab();
                this.casePanel.remove(this.currentView);
                this.currentView = null;
            }
            this.currentCase = model;
            this.currentView = (CaseDetailView)this.module.objectBuilderFactory().newObjectBuilder(CaseDetailView.class).use(new Object[]{model}).newInstance();
            if (selectedTab != -1) {
                this.currentView.setSelectedTab(selectedTab);
            }
            this.casePanel.add((Component)this.currentView, "Center");
            this.layout.show(this, "detail");
            this.currentView.requestFocusInWindow();
        }
    }

    public void clear() {
        this.layout.show(this, "blank");
        this.casePanel.removeAll();
        this.currentView = null;
        this.currentCase = null;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.currentView != null && this.currentView.requestFocusInWindow();
    }

    public CaseDetailView getCurrentCaseView() {
        return this.currentView;
    }

    public void refresh() {
        if (this.currentView != null) {
            this.layout.show(this, "blank");
            this.layout.show(this, "detail");
        }
    }

    public void selectCaseInTable(JTable cases) {
        if (this.currentCase != null) {
            WorkspaceView workspace;
            TableModel model = cases.getModel();
            boolean rowFound = false;
            int n = model.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (!this.currentCase.toString().endsWith(model.getValueAt(i, model.getColumnCount()).toString())) continue;
                cases.getSelectionModel().setSelectionInterval(cases.convertRowIndexToView(i), cases.convertRowIndexToView(i));
                cases.scrollRectToVisible(cases.getCellRect(i, 0, true));
                rowFound = true;
                break;
            }
            if (!(rowFound || (workspace = (WorkspaceView)SwingUtilities.getAncestorOfClass(WorkspaceView.class, this)) != null && workspace.getWorkspaceContext().showContext(this.currentCase))) {
                this.clear();
            }
        }
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (this.currentCase != null && Events.matches((Specification)Events.onEntityTypes((String[])new String[]{"se.streamsource.streamflow.web.domain.entity.caze.CaseEntity"}), transactions)) {
            if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedRemoved", "createdCase"}), transactions)) {
                this.clear();
            } else if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"open"}), transactions)) {
                this.clear();
            } else if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"sendto"}), transactions)) {
                this.clear();
            }
        }
    }
}

