/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.search;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.builder.ButtonBarBuilder2;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.specification.Specifications;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.ui.OptionsAction;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.search.PerspectivesModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class ManagePerspectivesDialog
extends JPanel
implements TransactionListener,
Refreshable {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private PerspectivesModel model;
    private JList perspective;
    private StreamflowButton optionButton;

    public ManagePerspectivesDialog(@Service ApplicationContext context, @Uses PerspectivesModel model) {
        super(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.model = model;
        this.perspective = new JList();
        this.perspective.setCellRenderer(new LinkListCellRenderer());
        this.perspective.setModel(new EventListModel(model.getList()));
        JScrollPane scroll = new JScrollPane(this.perspective);
        this.add((Component)scroll, "Center");
        JPopupMenu options = new JPopupMenu();
        javax.swing.Action removeAction = am.get("remove");
        javax.swing.Action renameAction = am.get("rename");
        options.add(removeAction);
        options.add(renameAction);
        this.perspective.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(removeAction, renameAction));
        this.optionButton = new StreamflowButton(new OptionsAction(options));
        ButtonBarBuilder2 buttonBuilder = new ButtonBarBuilder2();
        buttonBuilder.addButton((JComponent)this.optionButton);
        buttonBuilder.addUnrelatedGap();
        buttonBuilder.addGlue();
        buttonBuilder.addButton(am.get("close"));
        this.add((Component)buttonBuilder.getPanel(), "South");
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task remove() {
        if (!this.perspective.isSelectionEmpty()) {
            final LinkValue value = (LinkValue)this.perspective.getSelectedValue();
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ManagePerspectivesDialog.this.model.remove(value);
                }
            };
        }
        return null;
    }

    @Action
    public void close() {
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public Task rename() {
        final LinkValue selected = (LinkValue)this.perspective.getSelectedValue();
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(WorkspaceResources.change_perspective_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ManagePerspectivesDialog.this.model.changeDescription(selected, dialog.name());
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Specifications.and((Specification[])new Specification[]{Events.onEntityTypes((String[])new String[]{"se.streamsource.streamflow.web.domain.entity.user.UserEntity", "se.streamsource.streamflow.web.domain.entity.user.PerspectiveEntity"}), Events.withNames((String[])new String[]{"createdPerspective", "changedDescription", "removedPerspective"})}), transactions)) {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        this.model.refresh();
    }
}

