/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jdesktop.swingx.util.WindowUtils;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.api.workspace.cases.general.FormDraftDTO;
import se.streamsource.streamflow.api.workspace.cases.general.PageSubmissionDTO;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormDraftModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormSubmissionWizardPageView;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.PossibleFormView;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.PossibleFormsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class PossibleFormsView
extends JPanel
implements ActionListener,
Refreshable,
TransactionListener {
    @Structure
    Module module;
    @Service
    private StreamflowApplication main;
    @Service
    private DialogService dialogs;
    private PossibleFormsModel modelForms;
    private Wizard wizard;

    public PossibleFormsView(@Uses PossibleFormsModel possibleFormsModel) {
        this.modelForms = possibleFormsModel;
        this.setLayout(new GridLayout(0, 1));
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2));
        this.setFocusable(false);
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.modelForms.refresh();
        this.removeAll();
        EventList<LinkValue> formList = this.modelForms.getList();
        for (LinkValue itemValue : formList) {
            PossibleFormView formView = (PossibleFormView)this.module.objectBuilderFactory().newObjectBuilder(PossibleFormView.class).use(new Object[]{itemValue}).newInstance();
            formView.addActionListener(this);
            this.add((Component)formView, Float.valueOf(0.0f));
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Component component : this.getComponents()) {
            component.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof PossibleFormView) {
            PossibleFormView form = (PossibleFormView)e.getSource();
            final FormDraftModel formDraftModel = this.modelForms.getFormDraftModel((String)form.form().id().get());
            if (formDraftModel == null) {
                this.dialogs.showMessageDialog(this, i18n.text(WorkspaceResources.form_unavailable, new Object[0]), i18n.text((Enum)ErrorResources.information, new Object[0]));
                return;
            }
            FormDraftDTO formDraftDTO = (FormDraftDTO)formDraftModel.getFormDraftDTO().buildWith().prototype();
            if (((Boolean)formDraftDTO.visibilityrules().get()).booleanValue()) {
                this.dialogs.showMessageDialog(this, i18n.text((Enum)ErrorResources.prohibited_by_visibility_rule, new Object[0]), i18n.text((Enum)ErrorResources.information, new Object[0]));
                return;
            }
            final WizardPage[] wizardPages = new WizardPage[((List)formDraftDTO.pages().get()).size()];
            for (int i = 0; i < ((List)formDraftDTO.pages().get()).size(); ++i) {
                PageSubmissionDTO page = (PageSubmissionDTO)((List)formDraftDTO.pages().get()).get(i);
                if (page.fields().get() == null || ((List)page.fields().get()).size() <= 0) continue;
                wizardPages[i] = (WizardPage)this.module.objectBuilderFactory().newObjectBuilder(FormSubmissionWizardPageView.class).use(new Object[]{formDraftModel, page}).newInstance();
            }
            try {
                this.wizard = WizardPage.createWizard((String)((String)formDraftDTO.description().get()), (WizardPage[])wizardPages, (WizardPage.WizardResultProducer)new WizardPage.WizardResultProducer(){

                    public Object finish(Map map) throws WizardException {
                        Component focusOwner = WindowUtils.findWindow((Component)wizardPages[wizardPages.length - 1]).getFocusOwner();
                        if (focusOwner != null) {
                            focusOwner.transferFocus();
                            new CommandTask(){

                                @Override
                                protected void command() throws Exception {
                                    formDraftModel.submit();
                                }
                            }.execute();
                        }
                        return null;
                    }

                    public boolean cancel(Map map) {
                        return true;
                    }
                });
            }
            catch (NullPointerException npe) {
                throw new IllegalArgumentException(ErrorResources.form_page_without_fields.name());
            }
            Point onScreen = this.main.getMainFrame().getLocationOnScreen();
            WizardDisplayer.showWizard((Wizard)this.wizard, (Rectangle)new Rectangle(onScreen, new Dimension(800, 600)));
        }
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedOwner", "changedCaseType"}), transactions)) {
            this.refresh();
        }
    }
}

