/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.api.administration.form.OptionButtonsFieldValue;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.util.StateBinder;

public class OptionButtonsPanel
extends AbstractFieldPanel {
    private ButtonGroup group;

    public OptionButtonsPanel(@Uses FieldSubmissionDTO field, @Uses OptionButtonsFieldValue fieldValue) {
        super(field);
        JPanel panel = new JPanel(new BorderLayout());
        FormLayout formLayout = new FormLayout("200dlu", "");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(formLayout, panel);
        this.group = new ButtonGroup();
        for (String element : (List)fieldValue.values().get()) {
            JRadioButton button = new JRadioButton(element);
            this.group.add(button);
            formBuilder.append((Component)button);
            formBuilder.nextLine();
        }
        this.add((Component)panel, "West");
    }

    @Override
    public String getValue() {
        Enumeration<AbstractButton> buttonEnumeration = this.group.getElements();
        while (buttonEnumeration.hasMoreElements()) {
            AbstractButton button = buttonEnumeration.nextElement();
            if (!button.isSelected()) continue;
            return button.getText();
        }
        return "";
    }

    @Override
    public void setValue(String newValue) {
        Enumeration<AbstractButton> buttonEnumeration = this.group.getElements();
        while (buttonEnumeration.hasMoreElements()) {
            AbstractButton button = buttonEnumeration.nextElement();
            if (!button.getText().equals(newValue)) continue;
            this.group.setSelected(button.getModel(), true);
        }
    }

    @Override
    public void setBinding(final StateBinder.Binding binding) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                binding.updateProperty(OptionButtonsPanel.this.getValue());
            }
        };
        Enumeration<AbstractButton> buttonEnumeration = this.group.getElements();
        while (buttonEnumeration.hasMoreElements()) {
            AbstractButton button = buttonEnumeration.nextElement();
            button.addActionListener(listener);
        }
    }
}

