/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.api.administration.form.OpenSelectionFieldValue;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.util.Strings;

public class OpenSelectionPanel
extends AbstractFieldPanel {
    private ButtonGroup group;
    private JRadioButton openButton;
    private List<JRadioButton> selectionButtons;
    private JTextField openSelectionTextField;

    public OpenSelectionPanel(@Uses FieldSubmissionDTO field, @Uses OpenSelectionFieldValue fieldValue) {
        super(field);
        JPanel panel = new JPanel(new BorderLayout());
        FormLayout formLayout = new FormLayout("200dlu", "");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(formLayout, panel);
        this.group = new ButtonGroup();
        this.selectionButtons = new ArrayList<JRadioButton>(((List)fieldValue.values().get()).size());
        for (String element : (List)fieldValue.values().get()) {
            JRadioButton button = new JRadioButton(element);
            this.group.add(button);
            this.selectionButtons.add(button);
            formBuilder.append((Component)button);
            formBuilder.nextLine();
        }
        JPanel openPanel = new JPanel(new BorderLayout());
        this.openButton = new JRadioButton((String)fieldValue.openSelectionName().get());
        this.openSelectionTextField = new JTextField();
        openPanel.add((Component)this.openButton, "West");
        openPanel.add((Component)this.openSelectionTextField, "Center");
        this.group.add(this.openButton);
        formBuilder.append((Component)openPanel);
        this.setValue((String)field.value().get());
        this.add((Component)panel, "West");
    }

    @Override
    public String getValue() {
        if (this.openButton.isSelected()) {
            return this.openSelectionTextField.getText();
        }
        for (JRadioButton selectionButton : this.selectionButtons) {
            if (!selectionButton.isSelected()) continue;
            return selectionButton.getText();
        }
        return "";
    }

    @Override
    public void setValue(String newValue) {
        for (JRadioButton selectionButton : this.selectionButtons) {
            if (!selectionButton.getText().equals(newValue)) continue;
            this.openSelectionTextField.setText("");
            this.openSelectionTextField.setEnabled(false);
            selectionButton.setSelected(true);
            return;
        }
        if (!Strings.empty((String)newValue)) {
            this.openButton.setSelected(true);
            this.openSelectionTextField.setText(newValue);
            this.openSelectionTextField.setEnabled(true);
        }
    }

    @Override
    public void setBinding(final StateBinder.Binding binding) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSelectionPanel.this.openSelectionTextField.setText("");
                OpenSelectionPanel.this.openSelectionTextField.setEnabled(false);
                binding.updateProperty(OpenSelectionPanel.this.getValue());
            }
        };
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenSelectionPanel.this.openSelectionTextField.setEnabled(true);
            }
        });
        this.openSelectionTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                binding.updateProperty(((JTextComponent)input).getText());
                return true;
            }
        });
        for (JRadioButton selectionButton : this.selectionButtons) {
            selectionButton.addActionListener(listener);
        }
    }
}

