/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.util.ValidationUtils;
import com.jgoodies.validation.view.ValidationResultViewFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.ScrollableSizeHint;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.Property;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.DateFunctions;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.resource.ResourceException;
import se.streamsource.streamflow.api.administration.form.AttachmentFieldValue;
import se.streamsource.streamflow.api.administration.form.CheckboxesFieldValue;
import se.streamsource.streamflow.api.administration.form.ComboBoxFieldValue;
import se.streamsource.streamflow.api.administration.form.CommentFieldValue;
import se.streamsource.streamflow.api.administration.form.DateFieldValue;
import se.streamsource.streamflow.api.administration.form.FieldDefinitionValue;
import se.streamsource.streamflow.api.administration.form.FieldGroupFieldValue;
import se.streamsource.streamflow.api.administration.form.FieldValue;
import se.streamsource.streamflow.api.administration.form.GeoLocationFieldValue;
import se.streamsource.streamflow.api.administration.form.ListBoxFieldValue;
import se.streamsource.streamflow.api.administration.form.NumberFieldValue;
import se.streamsource.streamflow.api.administration.form.OpenSelectionFieldValue;
import se.streamsource.streamflow.api.administration.form.OptionButtonsFieldValue;
import se.streamsource.streamflow.api.administration.form.TextAreaFieldValue;
import se.streamsource.streamflow.api.administration.form.TextFieldValue;
import se.streamsource.streamflow.api.workspace.cases.form.AttachmentFieldDTO;
import se.streamsource.streamflow.api.workspace.cases.form.AttachmentFieldSubmission;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.api.workspace.cases.general.PageSubmissionDTO;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AttachmentFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.CheckboxesPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.ComboBoxPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.DatePanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormDraftModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormSubmissionWizardPageModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.ListBoxPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.NumberPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.OpenSelectionPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.OptionButtonsPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.TextAreaFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.TextFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoLocationFieldPanel;
import se.streamsource.streamflow.client.util.BindingFormBuilder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.EventParameters;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class FormSubmissionWizardPageView
extends WizardPage
implements Observer,
TransactionListener {
    private Map<String, AbstractFieldPanel> componentFieldMap;
    private Map<StateBinder, EntityReference> fieldBinders;
    private ValidationResultModel validationResultModel;
    private FormSubmissionWizardPageModel model;
    private static final Map<Class<? extends FieldValue>, Class<? extends AbstractFieldPanel>> fields = new HashMap<Class<? extends FieldValue>, Class<? extends AbstractFieldPanel>>();
    @Structure
    Module module;

    public FormSubmissionWizardPageView(@Structure Module module, @Uses PageSubmissionDTO page, @Uses FormDraftModel model) {
        super((String)page.title().get());
        this.module = module;
        this.model = (FormSubmissionWizardPageModel)module.objectBuilderFactory().newObjectBuilder(FormSubmissionWizardPageModel.class).use(new Object[]{model}).newInstance();
        this.componentFieldMap = new HashMap<String, AbstractFieldPanel>();
        this.validationResultModel = new DefaultValidationResultModel();
        this.setLayout(new BorderLayout());
        JXPanel panel = new JXPanel((LayoutManager)new FormLayout());
        panel.setScrollableHeightHint(ScrollableSizeHint.VERTICAL_STRETCH);
        this.fieldBinders = new HashMap<StateBinder, EntityReference>(((List)page.fields().get()).size());
        FormLayout formLayout = new FormLayout("250dlu, 70dlu:grow", "");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(formLayout, (JPanel)panel);
        BindingFormBuilder bb = new BindingFormBuilder(formBuilder, null);
        for (FieldSubmissionDTO DTO : (List)page.fields().get()) {
            FieldValue fieldValue = (FieldValue)((FieldDefinitionValue)DTO.field().get()).fieldValue().get();
            if (fieldValue instanceof FieldGroupFieldValue) {
                bb.append(new JLabel("<html><b>" + (String)((FieldDefinitionValue)DTO.field().get()).description().get() + "</b>:</html>"));
                continue;
            }
            if (!(fieldValue instanceof CommentFieldValue)) {
                AbstractFieldPanel component = this.getComponent(DTO);
                this.componentFieldMap.put(((EntityReference)((FieldDefinitionValue)DTO.field().get()).field().get()).identity(), component);
                StateBinder stateBinder = component.bindComponent(bb, DTO);
                stateBinder.addObserver(this);
                this.fieldBinders.put(stateBinder, (EntityReference)((FieldDefinitionValue)DTO.field().get()).field().get());
                continue;
            }
            String comment = (String)((FieldDefinitionValue)DTO.field().get()).note().get();
            comment = comment.replaceAll("\n", "<br/>");
            JEditorPane commentPane = new JEditorPane("text/html", "<html>" + comment + "</html>");
            Font font = UIManager.getFont("Label.font");
            String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
            ((HTMLDocument)commentPane.getDocument()).getStyleSheet().addRule(bodyRule);
            commentPane.setOpaque(false);
            commentPane.setBorder(null);
            commentPane.setEditable(false);
            commentPane.setFocusable(true);
            commentPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        try {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (URISyntaxException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            bb.append(commentPane);
        }
        JComponent validationResultsComponent = ValidationResultViewFactory.createReportList((ValidationResultModel)this.validationResultModel);
        formBuilder.appendRow("top:30dlu:g");
        CellConstraints cc = new CellConstraints();
        formBuilder.add((Component)validationResultsComponent, cc.xywh(1, formBuilder.getRow() + 1, 1, 1, "fill, bottom"));
        JScrollPane scroll = new JScrollPane((Component)panel);
        this.add(scroll, "Center");
        this.createFocusListenerForComponents(panel, panel.getComponents());
    }

    private void createFocusListenerForComponents(final JXPanel main, Component[] components) {
        for (final Component component : components) {
            if (component instanceof AbstractFieldPanel) {
                Component firstFocusable = ((AbstractFieldPanel)component).firstFocusableComponent((AbstractFieldPanel)component);
                if (firstFocusable == null) continue;
                firstFocusable.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        Rectangle rectangle = component.getBounds();
                        rectangle.add(rectangle.getX(), rectangle.getY() - 21.0);
                        main.scrollRectToVisible(rectangle);
                    }
                });
                continue;
            }
            if (!component.isFocusable()) continue;
            component.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    main.scrollRectToVisible(component.getBounds());
                }
            });
        }
    }

    public WizardPanelNavResult allowNext(String s, Map map, Wizard wizard) {
        ValidationResult validation = this.validatePage();
        this.validationResultModel.setResult(validation);
        if (!validation.hasErrors()) {
            return WizardPanelNavResult.PROCEED;
        }
        return WizardPanelNavResult.REMAIN_ON_PAGE;
    }

    public WizardPanelNavResult allowBack(String stepName, Map settings, Wizard wizard) {
        return super.allowBack(stepName, settings, wizard);
    }

    public WizardPanelNavResult allowFinish(String s, Map map, Wizard wizard) {
        ValidationResult validationResult = this.validatePage();
        this.validationResultModel.setResult(validationResult);
        if (validationResult.hasErrors()) {
            return WizardPanelNavResult.REMAIN_ON_PAGE;
        }
        return WizardPanelNavResult.PROCEED;
    }

    private ValidationResult validatePage() {
        ValidationResult validationResult = new ValidationResult();
        for (AbstractFieldPanel component : this.componentFieldMap.values()) {
            String value = component.getValue();
            if (!component.mandatory() || !ValidationUtils.isEmpty((String)value)) continue;
            validationResult.addError(i18n.text(WorkspaceResources.mandatory_field_missing, new Object[0]) + ": " + component.title());
        }
        return validationResult;
    }

    @Override
    public void update(final Observable observable, Object arg) {
        block7: {
            final Property property = (Property)arg;
            if (property.qualifiedName().name().equals("value")) {
                try {
                    if (property.get() instanceof Date) {
                        new CommandTask(){

                            @Override
                            public void command() throws Exception {
                                FormSubmissionWizardPageView.this.model.updateField((EntityReference)FormSubmissionWizardPageView.this.fieldBinders.get(observable), DateFunctions.toUtcString((Date)((Date)property.get())));
                            }
                        }.execute();
                        break block7;
                    }
                    if (property.get() instanceof File) {
                        try {
                            final FileInputStream fin = new FileInputStream((File)property.get());
                            new CommandTask(){

                                @Override
                                protected void command() throws Exception {
                                    FormSubmissionWizardPageView.this.model.createAttachment((EntityReference)FormSubmissionWizardPageView.this.fieldBinders.get(observable), (File)property.get(), fin);
                                }
                            }.execute();
                            break block7;
                        }
                        catch (Exception e) {
                            throw new OperationException(CaseResources.could_not_upload_file, (Throwable)e);
                        }
                    }
                    new CommandTask(){

                        @Override
                        protected void command() throws Exception {
                            FormSubmissionWizardPageView.this.model.updateField((EntityReference)FormSubmissionWizardPageView.this.fieldBinders.get(observable), property.get().toString());
                        }
                    }.execute();
                }
                catch (ResourceException e) {
                    throw new OperationException(CaseResources.could_not_update_field, (Throwable)e);
                }
            }
        }
    }

    public void updateFieldPanel(String fieldId, String fieldValue) {
        AbstractFieldPanel panel = this.componentFieldMap.get(fieldId);
        if (panel != null && fieldValue != null && !fieldValue.equals(panel.getValue())) {
            panel.setValue(fieldValue);
        }
    }

    private AbstractFieldPanel getComponent(FieldSubmissionDTO field) {
        FieldValue fieldValue = (FieldValue)((FieldDefinitionValue)field.field().get()).fieldValue().get();
        Class<?> fieldValueType = fieldValue.getClass().getInterfaces()[0];
        return (AbstractFieldPanel)this.module.objectBuilderFactory().newObjectBuilder(fields.get(fieldValueType)).use(new Object[]{field, fieldValue, this.model}).newInstance();
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedFieldAttachmentValue"}), transactions)) {
            String value = EventParameters.getParameter((DomainEvent)((DomainEvent)Iterables.first((Iterable)Iterables.filter((Specification)Events.withNames((String[])new String[]{"changedFieldAttachmentValue"}), (Iterable)Events.events(transactions)))), (String)"param1");
            AttachmentFieldDTO dto = (AttachmentFieldDTO)this.module.valueBuilderFactory().newValueFromJSON(AttachmentFieldDTO.class, value);
            ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(AttachmentFieldSubmission.class);
            ((AttachmentFieldSubmission)builder.prototype()).attachment().set(dto.attachment().get());
            ((AttachmentFieldSubmission)builder.prototype()).name().set(dto.name().get());
            this.updateFieldPanel(((EntityReference)dto.field().get()).identity(), ((AttachmentFieldSubmission)builder.newInstance()).toJSON());
        } else if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedFieldValue"}), transactions)) {
            DomainEvent event = (DomainEvent)Iterables.first((Iterable)Iterables.filter((Specification)Events.withNames((String[])new String[]{"changedFieldValue"}), (Iterable)Events.events(transactions)));
            String fieldId = EventParameters.getParameter((DomainEvent)event, (String)"param1");
            String value = EventParameters.getParameter((DomainEvent)event, (String)"param2");
            this.updateFieldPanel(fieldId, value);
        }
    }

    static {
        fields.put(CheckboxesFieldValue.class, CheckboxesPanel.class);
        fields.put(ComboBoxFieldValue.class, ComboBoxPanel.class);
        fields.put(DateFieldValue.class, DatePanel.class);
        fields.put(ListBoxFieldValue.class, ListBoxPanel.class);
        fields.put(NumberFieldValue.class, NumberPanel.class);
        fields.put(OptionButtonsFieldValue.class, OptionButtonsPanel.class);
        fields.put(OpenSelectionFieldValue.class, OpenSelectionPanel.class);
        fields.put(TextAreaFieldValue.class, TextAreaFieldPanel.class);
        fields.put(TextFieldValue.class, TextFieldPanel.class);
        fields.put(AttachmentFieldValue.class, AttachmentFieldPanel.class);
        fields.put(GeoLocationFieldValue.class, GeoLocationFieldPanel.class);
    }
}

