/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.StringValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.api.workspace.cases.attachment.UpdateAttachmentDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.StreetSearchDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.StreetsDTO;
import se.streamsource.streamflow.api.workspace.cases.form.AttachmentFieldDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FieldValueDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FormDraftDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FormDraftSettingsDTO;

public class FormDraftModel {
    @Uses
    CommandQueryClient client;
    @Structure
    Module module;

    public FormDraftDTO getFormDraftDTO() {
        return (FormDraftDTO)this.client.query("index", FormDraftDTO.class);
    }

    public void updateField(FieldValueDTO fieldValueDTO) {
        this.client.putCommand("updatefield", (Object)fieldValueDTO);
    }

    public void updateAttachment(String attachmentId, UpdateAttachmentDTO updateAttachmentDTO) {
        this.client.getClient("formattachments/" + attachmentId + "/").postCommand("update", (Object)updateAttachmentDTO);
    }

    public void updateAttachmentField(AttachmentFieldDTO attachmentFieldDTO) {
        this.client.putCommand("updateattachmentfield", (Object)attachmentFieldDTO);
    }

    public void createAttachment(Representation input) {
        this.client.getClient("formattachments/").postCommand("createformattachment", (Object)input);
    }

    public String kartagoclientexe(LinkValue link) {
        StringValue value = (StringValue)this.client.queryLink(link, StringValue.class);
        return (String)value.string().get();
    }

    public boolean isStreetLookupEnabled() {
        ResourceValue resource = this.client.query();
        return Iterables.matchesAny((Specification)Links.withRel((String)"searchstreets"), (Iterable)((Iterable)resource.queries().get()));
    }

    public StreetsDTO searchStreets(String query) throws ResourceException {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(StreetSearchDTO.class);
        ((StreetSearchDTO)builder.prototype()).address().set((Object)query);
        return (StreetsDTO)this.client.query("searchstreets", StreetsDTO.class, builder.newInstance());
    }

    public void submit() {
        this.client.putCommand("submit");
    }

    public void delete() {
        this.client.delete();
    }

    public FormDraftSettingsDTO settings() {
        return (FormDraftSettingsDTO)this.client.query("settings", FormDraftSettingsDTO.class);
    }
}

