/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseLabelsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class CaseLabelsView
extends JPanel
implements ListEventListener,
TransactionListener {
    @Service
    private DialogService dialogs;
    @Structure
    Module module;
    private CaseLabelsModel model;
    private StreamflowButton actionButton;
    private boolean textBold;

    public CaseLabelsView(@Service ApplicationContext context, @Uses CaseLabelsModel model) {
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        MacOsUIWrapper.convertAccelerators((ActionMap)context.getActionMap(CaseLabelsView.class, (Object)this));
        this.model = model;
        model.getLabels().addListEventListener((ListEventListener)this);
        this.setLayout(new FlowLayout(0));
        new RefreshWhenShowing(this, model);
    }

    public CaseLabelsModel getModel() {
        return this.model;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component component : this.getComponents()) {
            component.setEnabled(enabled);
        }
    }

    public void listChanged(ListEvent listEvent) {
        this.removeAll();
        for (int i = 0; i < this.model.getLabels().size(); ++i) {
            LinkValue linkValue = (LinkValue)this.model.getLabels().get(i);
            LinkValue knowledgeBase = null;
            try {
                knowledgeBase = this.model.getKnowledgeBaseLink(linkValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RemovableLabel label = new RemovableLabel(linkValue, knowledgeBase);
            if (this.textBold) {
                label.getLabel().setFont(label.getLabel().getFont().deriveFont(1));
            }
            label.setToolTipText((String)linkValue.text().get());
            label.getButton().addActionListener(this.getActionMap().get("remove"));
            label.setEnabled(this.isEnabled());
            this.add(label);
        }
        this.revalidate();
        this.repaint();
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task addLabel() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleLabels()}).newInstance();
        dialog.setSelectionMode(2);
        this.dialogs.showOkCancelHelpDialog(this.actionButton == null ? this : this.actionButton, dialog);
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                for (LinkValue listItemValue : dialog.getSelectedLinks()) {
                    CaseLabelsView.this.model.addLabel(listItemValue);
                }
            }
        };
    }

    @Action
    public Task remove(final ActionEvent e) {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                Component component = (Component)e.getSource();
                RemovableLabel label = (RemovableLabel)component.getParent();
                CaseLabelsView.this.model.removeLabel(label.getRemoveLink());
            }
        };
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedLabel", "removedLabel", "changedStatus"}), transactions)) {
            this.model.refresh();
            if (this.actionButton != null) {
                this.actionButton.requestFocusInWindow();
            }
        }
    }

    public void setButtonRelation(StreamflowButton button) {
        this.actionButton = button;
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaseLabelsView.this.actionButton.requestFocusInWindow();
            }
        });
    }

    public void setTextBold(boolean textBold) {
        this.textBold = textBold;
    }
}

