/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.workspace.cases.attachment.AttachmentDTO;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.attachments.AttachmentsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.OpenAttachmentTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.WrapLayout;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class MessageDraftAttachmentsView
extends JPanel
implements Refreshable,
TransactionListener {
    @Structure
    Module module;
    @Service
    DialogService dialogs;
    AttachmentsModel model;
    JPanel attachmentsPanel;
    Map<StreamflowButton, AttachmentDTO> openFileMap = new HashMap<StreamflowButton, AttachmentDTO>();
    ActionMap am;

    public MessageDraftAttachmentsView(@Service ApplicationContext context, @Uses AttachmentsModel model) {
        this.model = model;
        this.am = context.getActionMap((Object)this);
        this.setLayout(new BorderLayout());
        FormLayout formLayout = new FormLayout("pref,4dlu,pref:grow", "40dlu");
        PanelBuilder builder = new PanelBuilder(formLayout);
        StreamflowButton addButton = new StreamflowButton(this.am.get("add"));
        builder.add((Component)addButton);
        builder.nextColumn(2);
        this.attachmentsPanel = new JPanel(new WrapLayout(0));
        JScrollPane scroll = new JScrollPane();
        scroll.setBorder(BorderFactory.createEmptyBorder());
        scroll.setViewportView(this.attachmentsPanel);
        builder.add((Component)scroll);
        this.add((Component)builder.getPanel(), "Center");
        new RefreshWhenShowing(this, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (!Events.matches((Specification)Events.onEntityTypes((String[])new String[]{"se.streamsource.streamflow.web.domain.entity.conversation.ConversationEntity"}), transactions)) return;
        if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"delete"}), transactions)) {
            if (!Events.matches((Specification)Events.withNames((String[])new String[]{"removedAttachment"}), transactions)) return;
            this.refresh();
            return;
        } else {
            if (!Events.matches((Specification)Events.withNames((String[])new String[]{"addedAttachment"}), transactions)) return;
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        this.attachmentsPanel.removeAll();
        this.openFileMap.clear();
        this.model.refresh();
        Iterator iterator = this.model.getEventList().iterator();
        while (iterator.hasNext()) {
            AttachmentDTO attachmentIn;
            final AttachmentDTO attachment = attachmentIn = (AttachmentDTO)iterator.next();
            JPanel attachmentPanel = new JPanel(new FlowLayout(0));
            StreamflowButton openButton = new StreamflowButton((String)attachment.text().get(), i18n.icon(Icons.attachments, 14));
            openButton.setBorder(BorderFactory.createEmptyBorder());
            this.openFileMap.put(openButton, attachment);
            openButton.addActionListener(this.am.get("open"));
            attachmentPanel.add(openButton);
            StreamflowButton removeButton = new StreamflowButton(i18n.icon(Icons.drop, 14));
            removeButton.setBorder(BorderFactory.createEmptyBorder());
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfirmationDialog dialog = (ConfirmationDialog)MessageDraftAttachmentsView.this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
                    dialog.setRemovalMessage(i18n.text(WorkspaceResources.attachment, new Object[0]));
                    MessageDraftAttachmentsView.this.dialogs.showOkCancelHelpDialog(MessageDraftAttachmentsView.this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
                    if (dialog.isConfirmed()) {
                        new CommandTask(){

                            @Override
                            public void command() throws Exception {
                                try {
                                    MessageDraftAttachmentsView.this.model.removeAttachment(attachment);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        }.execute();
                    }
                }
            });
            attachmentPanel.add(removeButton);
            this.attachmentsPanel.add(attachmentPanel);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageDraftAttachmentsView.this.revalidate();
                MessageDraftAttachmentsView.this.repaint();
            }
        });
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task open(ActionEvent e) throws IOException {
        AttachmentDTO attachment = this.openFileMap.get(e.getSource());
        return new OpenAttachmentTask((String)attachment.text().get(), (String)attachment.href().get(), this, this.model, this.dialogs);
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task add() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        if (fileChooser.showDialog(this, i18n.text(WorkspaceResources.create_attachment, new Object[0])) == 0) {
            File[] selectedFiles = fileChooser.getSelectedFiles();
            return new AddAttachmentTask(selectedFiles);
        }
        return null;
    }

    private class AddAttachmentTask
    extends CommandTask {
        File[] selectedFiles;

        private AddAttachmentTask(File[] selectedFiles) {
            this.selectedFiles = selectedFiles;
        }

        @Override
        public void command() throws Exception {
            this.setTitle(this.getResourceMap().getString("title", new Object[0]));
            String message = this.getResourceMap().getString("message", new Object[0]);
            for (File file : this.selectedFiles) {
                this.setMessage(message + " " + file.getName());
                FileInputStream fin = new FileInputStream(file);
                MessageDraftAttachmentsView.this.model.createAttachment(file, fin);
            }
        }
    }
}

