/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.ConversationView;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.ConversationsListCellRenderer;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.ConversationsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class ConversationsView
extends JSplitPane
implements TransactionListener {
    @Structure
    Module module;
    @Service
    DialogService dialogs;
    private ConversationsModel model;
    private JList list;

    public ConversationsView(@Service ApplicationContext context, final @Uses ConversationsModel model) {
        this.model = model;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        MacOsUIWrapper.convertAccelerators(this.getActionMap());
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        JPanel left = new JPanel(new BorderLayout());
        left.setPreferredSize(new Dimension(200, 100));
        final CardLayout cards = new CardLayout();
        final JPanel right = new JPanel(cards);
        JPanel empty = new JPanel();
        right.add((Component)empty, "EMPTY");
        this.setRightComponent(right);
        cards.show(right, "EMPTY");
        this.list = new JList();
        this.list.setModel(new EventListModel(model.conversations()));
        this.list.setCellRenderer(new ConversationsListCellRenderer());
        this.list.setFixedCellHeight(-1);
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ConversationsView.this.list.getSelectedIndex() != -1 && !e.getValueIsAdjusting()) {
                    ConversationView conversationView = (ConversationView)ConversationsView.this.module.objectBuilderFactory().newObjectBuilder(ConversationView.class).use(new Object[]{model.newConversationModel((LinkValue)ConversationsView.this.list.getSelectedValue())}).newInstance();
                    ConversationsView.this.setRightComponent(conversationView);
                } else {
                    ConversationsView.this.setRightComponent(right);
                    cards.show(right, "EMPTY");
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.list, 20, 31);
        scroll.setMinimumSize(new Dimension(250, 100));
        left.add((Component)scroll, "Center");
        JPanel addPanel = new JPanel();
        javax.swing.Action addConversationAction = this.getActionMap().get("addConversation");
        StreamflowButton addConversation = new StreamflowButton(addConversationAction);
        addConversation.registerKeyboardAction(addConversationAction, (KeyStroke)addConversationAction.getValue("AcceleratorKey"), 2);
        addPanel.add((Component)addConversation, 0);
        left.add((Component)addPanel, "South");
        this.setLeftComponent(left);
        this.setDividerLocation(-1);
        model.addObserver(new RefreshComponents().enabledOn("create", addConversation));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task addConversation() throws ResourceException, IOException {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(CaseResources.new_conversation_topic, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ConversationsView.this.model.createConversation(dialog.name());
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"createdConversation"}), transactions)) {
            this.list.setSelectedIndex(this.model.conversations().size() - 1);
        }
    }
}

