/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.contacts;

import java.util.Observable;
import java.util.Observer;
import javax.swing.JTextField;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.streamflow.api.workspace.cases.contact.StreetSearchDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.StreetAddressSuggestModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.SuggestTextField;
import se.streamsource.streamflow.client.util.ValueBinder;

public class StreetAddressSuggestTextField
extends SuggestTextField<StreetSearchDTO>
implements Observer {
    private static final long serialVersionUID = -1952912369783423979L;
    private StreetAddressSuggestModel model;
    private final ValueBinder addressViewBinder;
    private final JTextField cityField;

    public StreetAddressSuggestTextField(StreetAddressSuggestModel model, JTextField cityField, ValueBinder addressViewBinder) {
        super(model);
        this.model = model;
        this.cityField = cityField;
        this.addressViewBinder = addressViewBinder;
        model.addObserver(this);
    }

    @Override
    public void handleAcceptAction(StreetSearchDTO selectedItem) {
        this.getTextField().setText((String)selectedItem.address().get());
        this.cityField.setText((String)selectedItem.area().get());
        this.model.getContactModel().getAddress().address().set(selectedItem.address().get());
        this.model.getContactModel().getAddress().city().set(selectedItem.area().get());
        this.addressViewBinder.update((ValueComposite)this.model.getContactModel().getAddress());
        this.model.getContactModel().changeAddressAndCity((String)selectedItem.address().get(), (String)selectedItem.area().get());
    }

    @Override
    public void handleSaveAction(final String text) {
        if (text != null && !text.equals(this.model.getContactModel().getAddress().address().get())) {
            new CommandTask(){

                @Override
                protected void command() throws Exception {
                    StreetAddressSuggestTextField.this.model.getContactModel().changeAddress(text);
                }
            }.execute();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.addressViewBinder.update((ValueComposite)this.model.getContactModel().getAddress());
    }
}

