/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.contacts;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactAddressDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactEmailDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactPhoneDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactsDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.ContactModel;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;

public class ContactsModel
extends Observable
implements Refreshable {
    @Structure
    Module module;
    @Uses
    private CommandQueryClient client;
    ContactModel currentContact;
    TransactionList<ContactDTO> eventList = new TransactionList((EventList)new BasicEventList());

    @Override
    public void refresh() {
        ResourceValue resource = this.client.query();
        ContactsDTO contactsDTO = (ContactsDTO)((ValueComposite)resource.index().get()).buildWith().prototype();
        EventListSynch.synchronize((Collection)contactsDTO.contacts().get(), this.eventList);
        this.setChanged();
        this.notifyObservers(resource);
    }

    public EventList<ContactDTO> getEventList() {
        return this.eventList;
    }

    public void createContact() {
        this.client.postCommand("add", this.module.valueBuilderFactory().newValue(ContactDTO.class));
    }

    public void removeElement(int selectedIndex) {
        this.client.getSubClient(selectedIndex + "").delete();
    }

    public ContactModel newContactModel(int idx) {
        ContactDTO contact = (ContactDTO)this.eventList.get(idx);
        this.createInitialValues(contact);
        this.currentContact = (ContactModel)this.module.objectBuilderFactory().newObjectBuilder(ContactModel.class).use(new Object[]{this.eventList.get(idx), this.client.getSubClient("" + idx)}).newInstance();
        return this.currentContact;
    }

    public ContactDTO createInitialValues(ContactDTO contact) {
        if (((List)contact.phoneNumbers().get()).isEmpty()) {
            ContactPhoneDTO phone = (ContactPhoneDTO)((ContactPhoneDTO)this.module.valueBuilderFactory().newValue(ContactPhoneDTO.class)).buildWith().prototype();
            ((List)contact.phoneNumbers().get()).add(phone);
        }
        if (((List)contact.addresses().get()).isEmpty()) {
            ContactAddressDTO address = (ContactAddressDTO)((ContactAddressDTO)this.module.valueBuilderFactory().newValue(ContactAddressDTO.class)).buildWith().prototype();
            ((List)contact.addresses().get()).add(address);
        }
        if (((List)contact.emailAddresses().get()).isEmpty()) {
            ContactEmailDTO email = (ContactEmailDTO)((ContactEmailDTO)this.module.valueBuilderFactory().newValue(ContactEmailDTO.class)).buildWith().prototype();
            ((List)contact.emailAddresses().get()).add(email);
        }
        return contact;
    }

    public ContactModel getCurrentContact() {
        return this.currentContact;
    }
}

