/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.attachments;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventJXTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.workspace.cases.attachment.AttachmentDTO;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.attachments.AttachmentsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.attachments.AttachmentsTableFormatter;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.OpenAttachmentTask;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class AttachmentsView
extends JPanel
implements TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private JXTable attachments;
    private EventJXTableModel<AttachmentDTO> tableModel;
    private AttachmentsModel attachmentsModel;

    public AttachmentsView(@Service ApplicationContext context, @Uses AttachmentsModel model) {
        this.setLayout(new BorderLayout());
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.attachmentsModel = model;
        AttachmentsTableFormatter tableFormat = new AttachmentsTableFormatter();
        this.tableModel = new EventJXTableModel(this.attachmentsModel.getEventList(), (TableFormat)tableFormat);
        this.attachments = new JXTable(this.tableModel);
        this.attachments.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        this.attachments.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        this.attachments.getColumn(0).setPreferredWidth(20);
        this.attachments.getColumn(0).setMaxWidth(20);
        this.attachments.getColumn(0).setResizable(false);
        this.attachments.getColumn(2).setPreferredWidth(100);
        this.attachments.getColumn(2).setMaxWidth(100);
        this.attachments.getColumn(3).setPreferredWidth(100);
        this.attachments.getColumn(3).setMaxWidth(100);
        this.attachments.setAutoCreateColumnsFromModel(false);
        this.attachments.addHighlighter(HighlighterFactory.createAlternateStriping());
        this.attachments.setModel(this.tableModel);
        this.attachments.setSelectionMode(0);
        JPanel toolbar = new JPanel();
        StreamflowButton addButton = new StreamflowButton(am.get("add"));
        toolbar.add(addButton);
        StreamflowButton removeButton = new StreamflowButton(am.get("remove"));
        toolbar.add(removeButton);
        StreamflowButton openButton = new StreamflowButton(am.get("open"));
        toolbar.add(openButton);
        this.attachments.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("open")));
        this.attachments.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(new javax.swing.Action[]{am.get("remove")}){

            @Override
            public boolean isSelectedValueValid(javax.swing.Action action) {
                return !AttachmentsView.this.attachments.getValueAt(AttachmentsView.this.attachments.convertRowIndexToModel(AttachmentsView.this.attachments.getSelectedRow()), 0).equals((Object)Icons.formSubmitted);
            }
        });
        this.attachmentsModel.addObserver(new RefreshComponents().visibleOn("createattachment", addButton, removeButton));
        this.attachments.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "open");
        this.attachments.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "remove");
        this.attachments.setActionMap((ActionMap)am);
        this.attachments.addMouseListener((MouseListener)new MouseAdapter((ActionMap)am, openButton){
            final /* synthetic */ ActionMap val$am;
            final /* synthetic */ StreamflowButton val$openButton;
            {
                this.val$am = actionMap;
                this.val$openButton = streamflowButton;
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                int obj = AttachmentsView.this.attachments.getSelectedRow();
                if (obj == -1) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    this.val$am.get("open").actionPerformed(new ActionEvent(this.val$openButton, 1001, "open"));
                    me.consume();
                }
            }
        });
        this.attachments.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel iconLabel = new JLabel(" ");
                switch ((Icons)((Object)value)) {
                    case attachments: {
                        iconLabel = new JLabel(i18n.icon((Icons)((Object)value), 11));
                        break;
                    }
                    case conversations: {
                        iconLabel = new JLabel(i18n.icon((Icons)((Object)value), 11));
                        break;
                    }
                    case formSubmitted: {
                        iconLabel = new JLabel(i18n.icon((Icons)((Object)value), 11));
                    }
                }
                iconLabel.setOpaque(true);
                if (isSelected) {
                    iconLabel.setBackground(AttachmentsView.this.attachments.getSelectionBackground());
                }
                return iconLabel;
            }
        });
        JScrollPane attachmentsScrollPane = new JScrollPane((Component)this.attachments);
        this.add((Component)attachmentsScrollPane, "Center");
        this.add((Component)toolbar, "South");
        new RefreshWhenShowing(this, this.attachmentsModel);
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task add() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        if (fileChooser.showDialog(this, i18n.text(WorkspaceResources.create_attachment, new Object[0])) == 0) {
            File[] selectedFiles = fileChooser.getSelectedFiles();
            return new AddAttachmentTask(selectedFiles);
        }
        return null;
    }

    @Action
    public Task remove() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage(i18n.text(this.attachments.getSelectedRows().length > 1 ? WorkspaceResources.attachments : WorkspaceResources.attachment, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            final ArrayList<Object> removedAttachments = new ArrayList<Object>();
            for (int i : this.attachments.getSelectedRows()) {
                removedAttachments.add(this.attachmentsModel.getEventList().get(this.attachments.convertRowIndexToModel(i)));
            }
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    for (AttachmentDTO removedAttachment : removedAttachments) {
                        AttachmentsView.this.attachmentsModel.removeAttachment(removedAttachment);
                    }
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task open() throws IOException {
        int n = 0;
        int[] nArray = this.attachments.getSelectedRows();
        int n2 = nArray.length;
        if (n < n2) {
            int i = nArray[n];
            AttachmentDTO attachment = (AttachmentDTO)this.attachmentsModel.getEventList().get(this.attachments.convertRowIndexToModel(i));
            return new OpenAttachmentTask((String)attachment.text().get(), (String)attachment.href().get(), this, this.attachmentsModel, this.dialogs);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"delete"}), transactions)) {
            if (!Events.matches((Specification)Events.withNames((String[])new String[]{"removedAttachment"}), transactions)) return;
            this.attachmentsModel.refresh();
            return;
        } else {
            if (!Events.matches((Specification)Events.withNames((String[])new String[]{"changedStatus", "addedAttachment"}), transactions)) return;
            this.attachmentsModel.refresh();
        }
    }

    private class AddAttachmentTask
    extends CommandTask {
        File[] selectedFiles;

        private AddAttachmentTask(File[] selectedFiles) {
            this.selectedFiles = selectedFiles;
        }

        @Override
        public void command() throws Exception {
            this.setTitle(this.getResourceMap().getString("title", new Object[0]));
            String message = this.getResourceMap().getString("message", new Object[0]);
            for (File file : this.selectedFiles) {
                this.setMessage(message + " " + file.getName());
                FileInputStream fin = new FileInputStream(file);
                AttachmentsView.this.attachmentsModel.createAttachment(file, fin);
            }
        }
    }
}

